/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.services;

import box.tapsi.libs.metrics.core.annotations.ReactiveTimed;
import box.tapsi.libs.scheduler.quartz.services.QuartzService;
import box.tapsi.libs.scheduler.scheduler.JobGroup;
import box.tapsi.libs.scheduler.scheduler.SchedulingExtensionsKt;
import box.tapsi.libs.scheduler.scheduler.SchedulingInstruction;
import box.tapsi.libs.scheduler.scheduler.Trigger;
import box.tapsi.libs.scheduler.scheduler.TriggerGroup;
import box.tapsi.libs.scheduler.scheduler.factories.QuartzJobDetailFactory;
import box.tapsi.libs.scheduler.scheduler.factories.QuartzTriggerFactory;
import box.tapsi.libs.scheduler.scheduler.services.SchedulerService;
import box.tapsi.libs.scheduler.scheduler.services.SchedulerServiceImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronExpression;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ReactiveTimed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001b\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/services/SchedulerServiceImpl;", "Lbox/tapsi/libs/scheduler/scheduler/services/SchedulerService;", "logger", "Lorg/slf4j/Logger;", "quartzTriggerFactory", "Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzTriggerFactory;", "quartzJobDetailFactory", "Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzJobDetailFactory;", "quartzService", "Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;", "(Lorg/slf4j/Logger;Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzTriggerFactory;Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzJobDetailFactory;Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;)V", "deleteJob", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "jobId", "", "jobGroup", "Lbox/tapsi/libs/scheduler/scheduler/JobGroup;", "getTriggers", "Lreactor/core/publisher/Flux;", "Lbox/tapsi/libs/scheduler/scheduler/Trigger;", "triggerGroup", "Lbox/tapsi/libs/scheduler/scheduler/TriggerGroup;", "reschedule", "triggerId", "trigger", "scheduleCronJob", "instruction", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction$Cron;", "scheduleRegularJob", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction$Regular;", "scheduler-starter"})
public class SchedulerServiceImpl
implements SchedulerService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final QuartzTriggerFactory quartzTriggerFactory;
    @NotNull
    private final QuartzJobDetailFactory quartzJobDetailFactory;
    @NotNull
    private final QuartzService quartzService;

    public SchedulerServiceImpl(@NotNull Logger logger, @NotNull QuartzTriggerFactory quartzTriggerFactory, @NotNull QuartzJobDetailFactory quartzJobDetailFactory, @NotNull QuartzService quartzService) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)quartzTriggerFactory, (String)"quartzTriggerFactory");
        Intrinsics.checkNotNullParameter((Object)quartzJobDetailFactory, (String)"quartzJobDetailFactory");
        Intrinsics.checkNotNullParameter((Object)quartzService, (String)"quartzService");
        this.logger = logger;
        this.quartzTriggerFactory = quartzTriggerFactory;
        this.quartzJobDetailFactory = quartzJobDetailFactory;
        this.quartzService = quartzService;
    }

    @Override
    @NotNull
    public Mono<Void> scheduleRegularJob(@NotNull SchedulingInstruction.Regular instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Mono mono = Mono.defer(() -> SchedulerServiceImpl.scheduleRegularJob$lambda$2(this, instruction));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer(...)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<Trigger> getTriggers(@NotNull TriggerGroup triggerGroup) {
        Intrinsics.checkNotNullParameter((Object)triggerGroup, (String)"triggerGroup");
        Flux flux = this.quartzService.getTriggers(triggerGroup.getValue()).map(arg_0 -> SchedulerServiceImpl.getTriggers$lambda$3((Function1)new Function1<org.quartz.Trigger, Trigger>(this){
            final /* synthetic */ SchedulerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Trigger invoke(org.quartz.Trigger it) {
                QuartzTriggerFactory quartzTriggerFactory = SchedulerServiceImpl.access$getQuartzTriggerFactory$p(this.this$0);
                Intrinsics.checkNotNull((Object)it);
                return quartzTriggerFactory.createTrigger(it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @Override
    @NotNull
    public Mono<Void> reschedule(@NotNull String triggerId, @NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)triggerId, (String)"triggerId");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Mono mono = Mono.defer(() -> SchedulerServiceImpl.reschedule$lambda$4(triggerId, trigger, this)).doOnSuccess(arg_0 -> SchedulerServiceImpl.reschedule$lambda$5((Function1)new Function1<Void, Unit>(this, triggerId, trigger){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ String $triggerId;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$triggerId = $triggerId;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Void it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Rescheduled trigger with id " + this.$triggerId + " in group " + this.$trigger.getTriggerGroup().getValue() + " for " + this.$trigger.getStartTimestamp());
            }
        }, arg_0)).doOnError(arg_0 -> SchedulerServiceImpl.reschedule$lambda$6((Function1)new Function1<Throwable, Unit>(this, triggerId, trigger){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ String $triggerId;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$triggerId = $triggerId;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Throwable it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).error("Error rescheduling trigger with id " + this.$triggerId + " in group " + this.$trigger.getTriggerGroup().getValue() + " for " + this.$trigger.getStartTimestamp(), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> scheduleCronJob(@NotNull SchedulingInstruction.Cron instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Mono mono = Mono.defer(() -> SchedulerServiceImpl.scheduleCronJob$lambda$7(this, instruction)).doOnError(arg_0 -> SchedulerServiceImpl.scheduleCronJob$lambda$8(scheduleCronJob.2.INSTANCE, arg_0), arg_0 -> SchedulerServiceImpl.scheduleCronJob$lambda$9((Function1)new Function1<Throwable, Unit>(this, instruction){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ SchedulingInstruction.Cron $instruction;
            {
                this.this$0 = $receiver;
                this.$instruction = $instruction;
                super(1);
            }

            public final void invoke(Throwable it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Cron job with id " + SchedulingExtensionsKt.getCompositeJobId(this.$instruction) + " already exists");
            }
        }, arg_0)).onErrorComplete(ObjectAlreadyExistsException.class).doOnSuccess(arg_0 -> SchedulerServiceImpl.scheduleCronJob$lambda$10((Function1)new Function1<Void, Unit>(this, instruction){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ SchedulingInstruction.Cron $instruction;
            {
                this.this$0 = $receiver;
                this.$instruction = $instruction;
                super(1);
            }

            public final void invoke(Void it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Scheduled cron job with id " + SchedulingExtensionsKt.getCompositeJobId(this.$instruction) + " at " + new CronExpression(this.$instruction.getCronExpression()).getExpressionSummary());
            }
        }, arg_0)).doOnError(arg_0 -> SchedulerServiceImpl.scheduleCronJob$lambda$11((Function1)new Function1<Throwable, Unit>(this, instruction){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ SchedulingInstruction.Cron $instruction;
            {
                this.this$0 = $receiver;
                this.$instruction = $instruction;
                super(1);
            }

            public final void invoke(Throwable it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).error("Error scheduling cron job with id " + SchedulingExtensionsKt.getCompositeJobId(this.$instruction) + " at " + new CronExpression(this.$instruction.getCronExpression()).getExpressionSummary(), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> deleteJob(@NotNull String jobId, @NotNull JobGroup jobGroup) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        Intrinsics.checkNotNullParameter((Object)jobGroup, (String)"jobGroup");
        Mono mono = Mono.just((Object)jobId).doOnNext(arg_0 -> SchedulerServiceImpl.deleteJob$lambda$12((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ SchedulerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(String it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Deleting the regular job with id " + it);
            }
        }, arg_0)).map(arg_0 -> SchedulerServiceImpl.deleteJob$lambda$13((Function1)new Function1<String, JobKey>(jobId, jobGroup){
            final /* synthetic */ String $jobId;
            final /* synthetic */ JobGroup $jobGroup;
            {
                this.$jobId = $jobId;
                this.$jobGroup = $jobGroup;
                super(1);
            }

            public final JobKey invoke(String it) {
                return new JobKey(this.$jobId, this.$jobGroup.getValue());
            }
        }, arg_0)).flatMap(arg_0 -> SchedulerServiceImpl.deleteJob$lambda$14((Function1)new Function1<JobKey, Mono<? extends Void>>(this){
            final /* synthetic */ SchedulerServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends Void> invoke(JobKey jobKey) {
                QuartzService quartzService = SchedulerServiceImpl.access$getQuartzService$p(this.this$0);
                Intrinsics.checkNotNull((Object)jobKey);
                return quartzService.deleteJob(jobKey);
            }
        }, arg_0)).doOnSuccess(arg_0 -> SchedulerServiceImpl.deleteJob$lambda$15((Function1)new Function1<Void, Unit>(this, jobId){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ String $jobId;
            {
                this.this$0 = $receiver;
                this.$jobId = $jobId;
                super(1);
            }

            public final void invoke(Void it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Deleted the regular job with id " + this.$jobId);
            }
        }, arg_0)).doOnError(arg_0 -> SchedulerServiceImpl.deleteJob$lambda$16((Function1)new Function1<Throwable, Unit>(this, jobId){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ String $jobId;
            {
                this.this$0 = $receiver;
                this.$jobId = $jobId;
                super(1);
            }

            public final void invoke(Throwable it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).error("Error deleting the regular job with id " + this.$jobId, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    private static final void scheduleRegularJob$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void scheduleRegularJob$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono scheduleRegularJob$lambda$2(SchedulerServiceImpl this$0, SchedulingInstruction.Regular $instruction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$instruction, (String)"$instruction");
        JobDetail jobDetail = this$0.quartzJobDetailFactory.createQuartzJobDetail($instruction);
        org.quartz.Trigger quartzTrigger = this$0.quartzTriggerFactory.createQuartzTrigger($instruction);
        this$0.logger.info("Scheduling a regular job with id " + jobDetail.getKey() + " at " + $instruction.getFireTimestamp());
        return this$0.quartzService.scheduleJob(jobDetail, quartzTrigger).doOnSuccess(arg_0 -> SchedulerServiceImpl.scheduleRegularJob$lambda$2$lambda$0((Function1)new Function1<Void, Unit>(this$0, jobDetail, $instruction){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            final /* synthetic */ SchedulingInstruction.Regular $instruction;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                this.$instruction = $instruction;
                super(1);
            }

            public final void invoke(Void it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).info("Scheduled regular job with id " + this.$jobDetail.getKey() + " at " + this.$instruction.getFireTimestamp());
            }
        }, arg_0)).doOnError(arg_0 -> SchedulerServiceImpl.scheduleRegularJob$lambda$2$lambda$1((Function1)new Function1<Throwable, Unit>(this$0, jobDetail, $instruction){
            final /* synthetic */ SchedulerServiceImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            final /* synthetic */ SchedulingInstruction.Regular $instruction;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                this.$instruction = $instruction;
                super(1);
            }

            public final void invoke(Throwable it) {
                SchedulerServiceImpl.access$getLogger$p(this.this$0).error("Error scheduling a regular job with id " + this.$jobDetail.getKey() + " at " + this.$instruction.getFireTimestamp(), it);
            }
        }, arg_0));
    }

    private static final Trigger getTriggers$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Trigger)$tmp0.invoke(p0);
    }

    private static final Mono reschedule$lambda$4(String $triggerId, Trigger $trigger, SchedulerServiceImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)$triggerId, (String)"$triggerId");
        Intrinsics.checkNotNullParameter((Object)$trigger, (String)"$trigger");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TriggerKey triggerKey = TriggerKey.triggerKey((String)$triggerId, (String)$trigger.getTriggerGroup().getValue());
        org.quartz.Trigger quartzTrigger = this$0.quartzTriggerFactory.createQuartzTrigger($trigger);
        QuartzService quartzService = this$0.quartzService;
        Intrinsics.checkNotNull((Object)triggerKey);
        return quartzService.rescheduleJob(triggerKey, quartzTrigger);
    }

    private static final void reschedule$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void reschedule$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono scheduleCronJob$lambda$7(SchedulerServiceImpl this$0, SchedulingInstruction.Cron $instruction) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$instruction, (String)"$instruction");
        JobDetail jobDetail = this$0.quartzJobDetailFactory.createQuartzJobDetail($instruction);
        this$0.logger.info("Scheduling a cron job with id " + jobDetail.getKey() + " at " + new CronExpression($instruction.getCronExpression()).getExpressionSummary());
        org.quartz.Trigger quartzTrigger = this$0.quartzTriggerFactory.createQuartzTrigger($instruction);
        return this$0.quartzService.scheduleJob(jobDetail, quartzTrigger);
    }

    private static final boolean scheduleCronJob$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void scheduleCronJob$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void scheduleCronJob$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void scheduleCronJob$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final JobKey deleteJob$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JobKey)$tmp0.invoke(p0);
    }

    private static final Mono deleteJob$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ QuartzTriggerFactory access$getQuartzTriggerFactory$p(SchedulerServiceImpl $this) {
        return $this.quartzTriggerFactory;
    }

    public static final /* synthetic */ Logger access$getLogger$p(SchedulerServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ QuartzService access$getQuartzService$p(SchedulerServiceImpl $this) {
        return $this.quartzService;
    }
}

