/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.store;

import jakarta.annotation.PreDestroy;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0005J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/store/JobStore;", "", "()V", "store", "", "", "(Ljava/util/Map;)V", "contains", "", "key", "destroy", "", "get", "getAll", "", "getInt", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getString", "put", "value", "remove", "scheduler-starter"})
public final class JobStore {
    @NotNull
    private final Map<String, Object> store;

    public JobStore() {
        this.store = new LinkedHashMap();
    }

    public JobStore(@NotNull Map<String, Object> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        this.store = store;
    }

    public final void put(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.store.put(key, value);
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.store.get(key);
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.store.containsKey(key);
    }

    @Nullable
    public final String getString(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.get(key);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            String string2 = it instanceof String ? (String)it : null;
            if (string2 == null) {
                string2 = string = it.toString();
            }
            if (string2 == null) {
                boolean bl2 = false;
                String string3 = "Value for key " + key + " is not a string";
                throw new IllegalArgumentException(string3.toString());
            }
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final Integer getInt(@NotNull String key) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.get(key);
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Integer n2 = it instanceof Integer ? (Integer)it : null;
            if (n2 == null) {
                n2 = StringsKt.toIntOrNull((String)it.toString());
            }
            if (n2 == null) {
                boolean bl2 = false;
                String string = "Value for key " + key + " is not an integer";
                throw new IllegalArgumentException(string.toString());
            }
            n = ((Number)n2).intValue();
        } else {
            n = null;
        }
        return n;
    }

    @NotNull
    public final Map<String, Object> getAll() {
        return this.store;
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.store.remove(key);
    }

    @PreDestroy
    public final void destroy() {
        this.store.clear();
    }
}

