/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.utilities.security.token.services;

import box.tapsi.libs.utilities.security.SecurityProperties;
import box.tapsi.libs.utilities.security.token.TokenException;
import box.tapsi.libs.utilities.security.token.services.TokenService;
import box.tapsi.libs.utilities.time.TimeExtensionsKt;
import box.tapsi.libs.utilities.time.TimeOperator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.security.Keys;
import io.micrometer.core.annotation.Timed;
import java.security.Key;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Timed
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J1\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lbox/tapsi/libs/utilities/security/token/services/TokenServiceImpl;", "Lbox/tapsi/libs/utilities/security/token/services/TokenService;", "timeOperator", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "logger", "Lorg/slf4j/Logger;", "securityProperties", "Lbox/tapsi/libs/utilities/security/SecurityProperties;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lbox/tapsi/libs/utilities/time/TimeOperator;Lorg/slf4j/Logger;Lbox/tapsi/libs/utilities/security/SecurityProperties;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "jwtParser", "Lio/jsonwebtoken/JwtParser;", "kotlin.jvm.PlatformType", "secretKey", "Ljavax/crypto/SecretKey;", "createJwt", "", "expiryDurationInSeconds", "", "subject", "key", "valueObject", "", "parseJwt", "T", "token", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "utilities-starter"})
public final class TokenServiceImpl
implements TokenService {
    @NotNull
    private final TimeOperator timeOperator;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final SecretKey secretKey;
    private final JwtParser jwtParser;

    public TokenServiceImpl(@NotNull TimeOperator timeOperator, @NotNull Logger logger, @NotNull SecurityProperties securityProperties, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)timeOperator, (String)"timeOperator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)securityProperties, (String)"securityProperties");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.timeOperator = timeOperator;
        this.logger = logger;
        this.objectMapper = objectMapper;
        SecretKey secretKey = Keys.hmacShaKeyFor((byte[])Base64.getDecoder().decode(securityProperties.getToken().getJwt().getSecretKey()));
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"hmacShaKeyFor(...)");
        this.secretKey = secretKey;
        this.jwtParser = Jwts.parser().verifyWith(this.secretKey).build();
    }

    @Override
    @NotNull
    public String createJwt(long expiryDurationInSeconds, @Nullable String subject, @NotNull String key, @NotNull Object valueObject) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)valueObject, (String)"valueObject");
        JwtBuilder builder = Jwts.builder().json((Serializer)new JacksonSerializer(this.objectMapper)).claim(key, valueObject).issuedAt(TimeExtensionsKt.toDate(this.timeOperator.getCurrentTime())).expiration(TimeExtensionsKt.toDate(this.timeOperator.addToCurrentTime(expiryDurationInSeconds, TimeUnit.SECONDS))).signWith((Key)this.secretKey);
        String string = subject;
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder.subject(it);
        }
        String string2 = builder.compact();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"compact(...)");
        return string2;
    }

    @Override
    public <T> T parseJwt(@NotNull String token, @NotNull String key, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        TokenServiceImpl $this$parseJwt_u24lambda_u241 = this;
        boolean bl = false;
        try {
            Claims claims = (Claims)$this$parseJwt_u24lambda_u241.jwtParser.parseSignedClaims((CharSequence)token).getPayload();
            object = $this$parseJwt_u24lambda_u241.objectMapper.convertValue(claims.get((Object)key), clazz);
        }
        catch (ExpiredJwtException e) {
            $this$parseJwt_u24lambda_u241.logger.error("Expired token: " + token, (Throwable)e);
            throw TokenException.InvalidTokenException.Companion.createExpiredTokenException$default(TokenException.InvalidTokenException.Companion, token, null, 2, null);
        }
        catch (UnsupportedJwtException e) {
            $this$parseJwt_u24lambda_u241.logger.error("Invalid token: " + token, (Throwable)e);
            throw TokenException.InvalidTokenException.Companion.createCorruptedTokenException$default(TokenException.InvalidTokenException.Companion, token, null, 2, null);
        }
        catch (JwtException e) {
            $this$parseJwt_u24lambda_u241.logger.error("Invalid token: " + token, (Throwable)e);
            throw TokenException.InvalidTokenException.Companion.createCorruptedTokenException$default(TokenException.InvalidTokenException.Companion, token, null, 2, null);
        }
        catch (IllegalArgumentException e) {
            $this$parseJwt_u24lambda_u241.logger.error("Invalid token: " + token, (Throwable)e);
            throw TokenException.InvalidTokenException.Companion.createCorruptedTokenException$default(TokenException.InvalidTokenException.Companion, token, null, 2, null);
        }
        return (T)object;
    }
}

