/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.utilities.logging;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import org.slf4j.MDC;
import reactor.core.CoreSubscriber;
import reactor.util.context.Context;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0012B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lbox/tapsi/libs/utilities/logging/MdcContextLifter;", "T", "Lreactor/core/CoreSubscriber;", "coreSubscriber", "(Lreactor/core/CoreSubscriber;)V", "currentContext", "Lreactor/util/context/Context;", "onComplete", "", "onError", "throwable", "", "onNext", "t", "(Ljava/lang/Object;)V", "onSubscribe", "subscription", "Lorg/reactivestreams/Subscription;", "Companion", "utilities-starter"})
public final class MdcContextLifter<T>
implements CoreSubscriber<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreSubscriber<T> coreSubscriber;

    public MdcContextLifter(@NotNull CoreSubscriber<T> coreSubscriber) {
        Intrinsics.checkNotNullParameter(coreSubscriber, (String)"coreSubscriber");
        this.coreSubscriber = coreSubscriber;
    }

    public void onNext(T t) {
        Context context = this.coreSubscriber.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        MdcContextLifter.Companion.copyToMdc(context);
        this.coreSubscriber.onNext(t);
        MDC.remove((String)"trace_id");
    }

    public void onSubscribe(@NotNull Subscription subscription) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Context context = this.coreSubscriber.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        MdcContextLifter.Companion.copyToMdc(context);
        this.coreSubscriber.onSubscribe(subscription);
        MDC.remove((String)"trace_id");
    }

    public void onComplete() {
        Context context = this.coreSubscriber.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        MdcContextLifter.Companion.copyToMdc(context);
        this.coreSubscriber.onComplete();
        MDC.remove((String)"trace_id");
    }

    public void onError(@Nullable Throwable throwable) {
        Context context = this.coreSubscriber.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        MdcContextLifter.Companion.copyToMdc(context);
        this.coreSubscriber.onError(throwable);
        MDC.remove((String)"trace_id");
    }

    @NotNull
    public Context currentContext() {
        Context context = this.coreSubscriber.currentContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"currentContext(...)");
        return context;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"Lbox/tapsi/libs/utilities/logging/MdcContextLifter$Companion;", "", "()V", "copyToMdc", "", "Lreactor/util/context/Context;", "utilities-starter"})
    public static final class Companion {
        private Companion() {
        }

        private final void copyToMdc(Context $this$copyToMdc) {
            if ($this$copyToMdc.isEmpty()) {
                return;
            }
            String traceId = $this$copyToMdc.getOrEmpty((Object)"trace_id").orElse(null);
            if (traceId != null) {
                MDC.put((String)"trace_id", (String)traceId.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

