/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.utilities.security.autoconfigure;

import box.tapsi.libs.utilities.security.SecurityProperties;
import box.tapsi.libs.utilities.security.crypto.services.EncryptionService;
import box.tapsi.libs.utilities.security.crypto.services.EncryptionServiceImpl;
import box.tapsi.libs.utilities.security.hash.services.HashService;
import box.tapsi.libs.utilities.security.hash.services.HashServiceImpl;
import box.tapsi.libs.utilities.security.token.services.TokenService;
import box.tapsi.libs.utilities.security.token.services.TokenServiceImpl;
import box.tapsi.libs.utilities.time.TimeOperator;
import com.fasterxml.jackson.databind.ObjectMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

@AutoConfiguration(after={JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={SecurityProperties.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0017J\b\u0010\u0007\u001a\u00020\bH\u0017J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0017\u00a8\u0006\u0013"}, d2={"Lbox/tapsi/libs/utilities/security/autoconfigure/SecurityAutoConfiguration;", "", "()V", "encryptionService", "Lbox/tapsi/libs/utilities/security/crypto/services/EncryptionService;", "securityProperties", "Lbox/tapsi/libs/utilities/security/SecurityProperties;", "stringKeyGenerator", "Lorg/springframework/security/crypto/keygen/StringKeyGenerator;", "hashService", "Lbox/tapsi/libs/utilities/security/hash/services/HashService;", "tokenService", "Lbox/tapsi/libs/utilities/security/token/services/TokenService;", "timeOperator", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "logger", "Lorg/slf4j/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "utilities-starter"})
public class SecurityAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public StringKeyGenerator stringKeyGenerator() {
        StringKeyGenerator stringKeyGenerator = KeyGenerators.string();
        Intrinsics.checkNotNullExpressionValue((Object)stringKeyGenerator, (String)"string(...)");
        return stringKeyGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public EncryptionService encryptionService(@NotNull SecurityProperties securityProperties, @NotNull StringKeyGenerator stringKeyGenerator) {
        Intrinsics.checkNotNullParameter((Object)securityProperties, (String)"securityProperties");
        Intrinsics.checkNotNullParameter((Object)stringKeyGenerator, (String)"stringKeyGenerator");
        return new EncryptionServiceImpl(securityProperties, stringKeyGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    @NotNull
    public HashService hashService() {
        return new HashServiceImpl();
    }

    @Bean
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnMissingBean
    @NotNull
    public TokenService tokenService(@NotNull TimeOperator timeOperator, @NotNull Logger logger, @NotNull SecurityProperties securityProperties, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)timeOperator, (String)"timeOperator");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)securityProperties, (String)"securityProperties");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        return new TokenServiceImpl(timeOperator, logger, securityProperties, objectMapper);
    }
}

