/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.utilities.security.crypto.services;

import box.tapsi.libs.utilities.security.SecurityProperties;
import box.tapsi.libs.utilities.security.crypto.services.EncryptionService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.crypto.keygen.StringKeyGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lbox/tapsi/libs/utilities/security/crypto/services/EncryptionServiceImpl;", "Lbox/tapsi/libs/utilities/security/crypto/services/EncryptionService;", "securityProperties", "Lbox/tapsi/libs/utilities/security/SecurityProperties;", "stringKeyGenerator", "Lorg/springframework/security/crypto/keygen/StringKeyGenerator;", "(Lbox/tapsi/libs/utilities/security/SecurityProperties;Lorg/springframework/security/crypto/keygen/StringKeyGenerator;)V", "createEncryptors", "Lorg/springframework/security/crypto/encrypt/TextEncryptor;", "salt", "", "decrypt", "cipherText", "encrypt", "plainText", "generateSalt", "utilities-starter"})
public final class EncryptionServiceImpl
implements EncryptionService {
    @NotNull
    private final SecurityProperties securityProperties;
    @NotNull
    private final StringKeyGenerator stringKeyGenerator;

    public EncryptionServiceImpl(@NotNull SecurityProperties securityProperties, @NotNull StringKeyGenerator stringKeyGenerator) {
        Intrinsics.checkNotNullParameter((Object)securityProperties, (String)"securityProperties");
        Intrinsics.checkNotNullParameter((Object)stringKeyGenerator, (String)"stringKeyGenerator");
        this.securityProperties = securityProperties;
        this.stringKeyGenerator = stringKeyGenerator;
    }

    @Override
    @NotNull
    public String encrypt(@NotNull String plainText, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        String string = this.createEncryptors(salt).encrypt(plainText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
        return string;
    }

    @Override
    @NotNull
    public String decrypt(@NotNull String cipherText, @NotNull String salt) {
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        String string = this.createEncryptors(salt).decrypt(cipherText);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        return string;
    }

    @Override
    @NotNull
    public String generateSalt() {
        String string = this.stringKeyGenerator.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateKey(...)");
        return string;
    }

    private final TextEncryptor createEncryptors(String salt) {
        TextEncryptor textEncryptor = Encryptors.text((CharSequence)this.securityProperties.getCrypto().getKey(), (CharSequence)salt);
        Intrinsics.checkNotNullExpressionValue((Object)textEncryptor, (String)"text(...)");
        return textEncryptor;
    }
}

