/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.utilities.time;

import box.tapsi.libs.utilities.time.SupportedTimezone;
import box.tapsi.libs.utilities.time.TimeOperator;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J \u0010\"\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006#"}, d2={"Lbox/tapsi/libs/utilities/time/TimeOperatorImpl;", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "()V", "addToCurrentTime", "Ljava/time/Instant;", "offset", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "addToInstant", "time", "convertLocalDateToInstant", "localDate", "Ljava/time/LocalDate;", "timezone", "Lbox/tapsi/libs/utilities/time/SupportedTimezone;", "getCurrentDayOfWeek", "Ljava/time/DayOfWeek;", "getCurrentLocalDate", "getCurrentLocalTime", "Ljava/time/LocalTime;", "getCurrentTime", "getDurationBetween", "Ljava/time/Duration;", "startTime", "endTime", "getElapsedTimeFrom", "getStartOfTheDayTime", "isAfterCurrentLocalTime", "", "isAfterInstant", "otherTime", "isBeforeCurrentLocalTime", "isBeforeInstant", "subtractFromInstant", "utilities-starter"})
public final class TimeOperatorImpl
implements TimeOperator {
    @Override
    @NotNull
    public Instant addToCurrentTime(long offset, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Instant instant = Instant.now().plusMillis(timeUnit.toMillis(offset));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusMillis(...)");
        return instant;
    }

    @Override
    @NotNull
    public Instant getCurrentTime() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return instant;
    }

    @Override
    @NotNull
    public Instant addToInstant(@NotNull Instant time, long offset, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Instant instant = time.plusMillis(timeUnit.toMillis(offset));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plusMillis(...)");
        return instant;
    }

    @Override
    @NotNull
    public Instant subtractFromInstant(@NotNull Instant time, long offset, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Instant instant = time.minusMillis(timeUnit.toMillis(offset));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusMillis(...)");
        return instant;
    }

    @Override
    public boolean isBeforeInstant(@NotNull Instant time, @NotNull Instant otherTime) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)otherTime, (String)"otherTime");
        return time.isBefore(otherTime);
    }

    @Override
    @NotNull
    public Duration getDurationBetween(@NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Duration duration = Duration.between(startTime, endTime);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @Override
    @NotNull
    public Duration getElapsedTimeFrom(@NotNull Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Duration duration = Duration.between(startTime, this.getCurrentTime());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    @Override
    @NotNull
    public Instant getStartOfTheDayTime(@NotNull Instant time, @NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        Instant instant = LocalDate.ofInstant(time, timezone.asZoneId()).atStartOfDay(timezone.asZoneId()).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return instant;
    }

    @Override
    @NotNull
    public Instant convertLocalDateToInstant(@NotNull LocalDate localDate, @NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        Instant instant = localDate.atStartOfDay(timezone.asZoneId()).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return instant;
    }

    @Override
    @NotNull
    public LocalDate getCurrentLocalDate(@NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        LocalDate localDate = LocalDate.now(timezone.asZoneId());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        return localDate;
    }

    @Override
    @NotNull
    public DayOfWeek getCurrentDayOfWeek(@NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        DayOfWeek dayOfWeek = this.getCurrentLocalDate(timezone).getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    @Override
    public boolean isBeforeCurrentLocalTime(@NotNull LocalTime time, @NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        return time.isBefore(this.getCurrentLocalTime(timezone));
    }

    @Override
    public boolean isAfterCurrentLocalTime(@NotNull LocalTime time, @NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        return time.isAfter(this.getCurrentLocalTime(timezone));
    }

    @Override
    public boolean isAfterInstant(@NotNull Instant time, @NotNull Instant otherTime) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)otherTime, (String)"otherTime");
        return time.isAfter(otherTime);
    }

    @Override
    @NotNull
    public LocalTime getCurrentLocalTime(@NotNull SupportedTimezone timezone) {
        Intrinsics.checkNotNullParameter((Object)((Object)timezone), (String)"timezone");
        LocalTime localTime = LocalTime.now(timezone.asZoneId());
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"now(...)");
        return localTime;
    }
}

