/*
 * Decompiled with CFR 0.152.
 */
package entities.dao;

import entities.dao.DAOConstraintException;
import entities.dao.DAOException;
import entities.dao.DAOValidationException;
import entities.dao.IDAO;
import java.util.List;
import util.reflection.ObjectHelper;

public abstract class AbstractDAO
implements IDAO {
    private Class<?> entityClass = null;

    @Override
    public Class<?> getEntity() {
        return this.entityClass;
    }

    @Override
    public void setEntity(Class<?> entity) {
        if (this.entityClass != null) {
            throw new RuntimeException("Entity n\u00e3o pode ser modificado de " + this.entityClass.getName() + " para " + entity.getName());
        }
        this.entityClass = entity;
    }

    @Override
    public Object newInstance(Object entity) {
        return ObjectHelper.newInstance(entity);
    }

    @Override
    public abstract void save(Object ... var1) throws DAOValidationException, DAOConstraintException, DAOException;

    @Override
    public abstract void load(Object ... var1) throws DAOException;

    @Override
    public abstract Object lookup(Class var1, Object var2) throws DAOException;

    @Override
    public abstract void delete(Object ... var1) throws DAOConstraintException, DAOException;

    @Override
    public List query() throws DAOException {
        return this.query("From " + this.getEntity().getName(), 0, 0, (Object[])null);
    }

    @Override
    public List query(String oqlCommand) throws DAOException {
        return this.query(oqlCommand, 0, 0, (Object[])null);
    }

    @Override
    public List query(String oqlCommand, Object ... parameters) throws DAOException {
        return this.query(oqlCommand, 0, 0, parameters);
    }

    @Override
    public List query(String oqlCommand, int StartIndex, int MaxObjects) throws DAOException {
        return this.query(oqlCommand, StartIndex, MaxObjects, (Object[])null);
    }

    @Override
    public abstract List query(String var1, int var2, int var3, Object ... var4) throws DAOException;

    @Override
    public long queryCount(String oqlCommand) throws DAOException {
        return this.queryCount(oqlCommand, null);
    }

    @Override
    public abstract long queryCount(String var1, Object ... var2) throws DAOException;
}

