/*
 * Decompiled with CFR 0.152.
 */
package entities.dao;

import entities.annotations.DAOClass;
import entities.dao.IDAO;
import java.util.LinkedHashSet;
import java.util.Set;

public class DAOFactory {
    private static DAOFactory factory = new DAOFactory();
    private static Set<String> mapFiles = new LinkedHashSet<String>();
    private static String daoDefault = "entities.dao.hibernate.DAOHibernateNestedTransaction";

    public static DAOFactory getInstance() {
        return factory;
    }

    public Set<String> getMapFiles() {
        return mapFiles;
    }

    public DAOFactory addMapFiles(String mapFileName) {
        mapFiles.add(mapFileName);
        return factory;
    }

    public DAOFactory setDefaultDAO(String className) {
        daoDefault = className;
        return factory;
    }

    public IDAO getDAO(Class persistentClass) {
        IDAO dao;
        if (persistentClass == null || !persistentClass.isAnnotationPresent(DAOClass.class)) {
            try {
                dao = (IDAO)Class.forName(daoDefault).newInstance();
                dao.setEntity(persistentClass);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Classe " + daoDefault + " n\u00e3o existe", ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel instanciar a classe " + daoDefault, ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("N\u00e3o \u00e9 poss\u00edvel acessar a classe " + daoDefault, ex);
            }
        }
        DAOClass daoClassInfo = persistentClass.getAnnotation(DAOClass.class);
        try {
            dao = daoClassInfo.value().newInstance();
            dao.setEntity(persistentClass);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("A classe " + DAOClass.class.getName() + " n\u00e3o pode ser instanciada", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("A classe " + DAOClass.class.getName() + " n\u00e3o pode ser acessada", ex);
        }
        return dao;
    }
}

