/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.hibernate;

import entities.dao.AbstractDAO;
import entities.dao.DAOConstraintException;
import entities.dao.DAOException;
import entities.dao.DAOValidationException;
import entities.dao.hibernate.HibernateUtil;
import entities.dao.oql.OQL;
import entities.util.EntityHelper;
import entities.util.EntityValidator;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;

public class DAOHibernateNestedTransaction
extends AbstractDAO {
    private static final long serialVersionUID = -6735989557956391804L;

    private Session getCurrentSession() {
        return HibernateUtil.getSession(this.getEntity());
    }

    @Override
    public Object getDelegate() {
        return this.getCurrentSession();
    }

    @Override
    public void beginTransaction() throws DAOException {
        Session session = this.getCurrentSession();
        if (session.getTransaction().isActive()) {
            throw new DAOException("Transa\u00e7\u00e3o j\u00e1 iniciada");
        }
        this.getCurrentSession().getTransaction().begin();
    }

    @Override
    public void commit() {
        this.getCurrentSession().getTransaction().commit();
    }

    @Override
    public void rollback() {
        this.getCurrentSession().getTransaction().rollback();
    }

    @Override
    public void save(Object ... entities) throws DAOValidationException, DAOConstraintException, DAOException {
        if (entities == null) {
            throw new IllegalArgumentException("Entidade para salvar n\u00e3o pode ser null");
        }
        if (entities.length <= 0) {
            throw new IllegalArgumentException("Nenhuma Entidade foi informada para salva");
        }
        EntityValidator ev = new EntityValidator(entities);
        if (ev.hasErrors()) {
            throw new DAOValidationException(ev.getMessage());
        }
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            for (Object entity : entities) {
                session.saveOrUpdate(entity);
            }
            session.flush();
            if (entities.length > 1) {
                session.clear();
            }
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (InvalidStateException iexp) {
            StringBuilder msg = new StringBuilder();
            InvalidValue[] arr$ = iexp.getInvalidValues();
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                InvalidValue iv = arr$[i$];
                msg.append(iv.getPropertyName() + " : ");
                if (iv.getValue() != null) {
                    msg.append(" \"" + iv.getValue() + "\" ");
                }
                msg.append(" " + iv.getMessage() + "\n");
                throw new DAOValidationException(msg.toString());
            }
        }
        catch (ConstraintViolationException exp) {
            session.getTransaction().rollback();
            throw new DAOConstraintException(exp.getMessages()[exp.getMessages().length - 1], exp);
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
    }

    @Override
    public void load(Object ... entities) throws DAOException {
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            for (Object entity : entities) {
                if (!session.contains(entity)) {
                    session.load(entity, (Serializable)EntityHelper.getValueId(entity));
                    continue;
                }
                session.refresh(entity);
            }
            session.flush();
            if (entities.length > 1) {
                session.clear();
            }
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
    }

    @Override
    public Object lookup(Class entity, Object id) throws DAOException {
        Object obj = null;
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            obj = session.load(entity, (Serializable)id);
            session.flush();
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
        return obj;
    }

    @Override
    public void delete(Object ... entities) throws DAOException {
        if (entities == null) {
            throw new IllegalArgumentException("Entidade para dele\u00e7\u00e3o n\u00e3o pode ser null");
        }
        if (entities.length <= 0) {
            throw new IllegalArgumentException("Nenhuma Entidade foi informada para dele\u00e7\u00e3o");
        }
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            for (Object entity : entities) {
                session.load(entity, (Serializable)EntityHelper.getValueId(entity));
                session.delete(entity);
            }
            session.flush();
            if (entities.length > 1) {
                session.clear();
            }
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (ConstraintViolationException ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex.getMessages()[ex.getMessages().length - 1], ex);
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
    }

    @Override
    public List query(String oqlCommand, int StartIndex, int MaxObjects, Object ... parameters) throws DAOException {
        OQL oql = new OQL(oqlCommand);
        List list = null;
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            String select = oql.getOQLCommand();
            Query q = session.createQuery(select);
            String[] queryParams = oql.getParamNames();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (queryParams.length == 0) {
                        q.setParameter(i, parameters[i]);
                        continue;
                    }
                    q.setParameter(queryParams[i], parameters[i]);
                }
            }
            if (StartIndex > 0) {
                q.setFirstResult(StartIndex);
            }
            if (MaxObjects > 0) {
                q.setMaxResults(MaxObjects);
            }
            list = q.list();
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
        return list;
    }

    @Override
    public long queryCount(String oqlCommand, Object ... parameters) throws DAOException {
        Long count;
        OQL oql = new OQL(oqlCommand);
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            Query query = session.createQuery(oql.getOQLCountCommand());
            String[] queryParams = oql.getParamNames();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (queryParams.length == 0) {
                        query.setParameter(i, parameters[i]);
                        continue;
                    }
                    query.setParameter(queryParams[i], parameters[i]);
                }
            }
            count = (Long)query.uniqueResult();
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
        return count;
    }

    @Override
    public int executeUpdate(String oqlCommand, Object ... parameters) throws DAOException {
        int rowsAffect = 0;
        if (oqlCommand == null) {
            throw new IllegalArgumentException("Comando n\u00e3o pode ser null");
        }
        Session session = this.getCurrentSession();
        try {
            boolean isActive = session.getTransaction().isActive();
            if (!isActive) {
                session.beginTransaction();
            }
            Query query = session.createQuery(oqlCommand);
            String[] queryParams = this.extractParamNames(oqlCommand);
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (queryParams.length == 0) {
                        query.setParameter(i, parameters[i]);
                        continue;
                    }
                    query.setParameter(queryParams[i], parameters[i]);
                }
            }
            rowsAffect = query.executeUpdate();
            if (!isActive) {
                session.getTransaction().commit();
            }
        }
        catch (ConstraintViolationException ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex.getMessages()[ex.getMessages().length - 1], ex);
        }
        catch (Throwable ex) {
            session.getTransaction().rollback();
            throw new DAOException(ex);
        }
        return rowsAffect;
    }

    private String[] extractParamNames(String oql) {
        Pattern pattern = Pattern.compile(":\\w*");
        Matcher matcher = pattern.matcher(oql);
        LinkedList<String> linkedParams = new LinkedList<String>();
        while (matcher.find()) {
            linkedParams.add(matcher.group().substring(1));
        }
        return linkedParams.toArray(new String[linkedParams.size()]);
    }

    static {
        HibernateUtil.init();
    }
}

