/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.hibernate;

import entities.dao.AbstractDAO;
import entities.dao.DAOConstraintException;
import entities.dao.DAOException;
import entities.dao.DAOValidationException;
import entities.dao.hibernate.HibernateUtil;
import entities.dao.oql.OQL;
import entities.util.EntityHelper;
import entities.util.EntityValidator;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.exception.ConstraintViolationException;

public class DAOHibernateTransaction
extends AbstractDAO {
    private static final long serialVersionUID = -6735989557956391804L;

    private Session getSession(Class clazz) {
        return HibernateUtil.getSession(clazz);
    }

    private Session getSession(String className) {
        return HibernateUtil.getSession(className);
    }

    @Override
    public void beginTransaction() throws DAOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void save(Object ... entities) throws DAOValidationException, DAOConstraintException, DAOException {
        if (entities == null) {
            throw new IllegalArgumentException("Entidade para salvar n\u00e3o pode ser null");
        }
        if (entities.length <= 0) {
            throw new IllegalArgumentException("Nenhuma Entidade foi informada para salva");
        }
        EntityValidator ev = new EntityValidator(entities);
        if (ev.hasErrors()) {
            throw new DAOValidationException(ev.getMessage());
        }
        Session session = this.getSession(entities[0].getClass());
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            for (Object entity : entities) {
                session.saveOrUpdate(entity);
            }
            session.flush();
            utx.commit();
        }
        catch (ConstraintViolationException exp) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOConstraintException(exp.getMessages()[exp.getMessages().length - 1], exp);
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public void load(Object ... entities) throws DAOException {
        Session session = this.getSession(entities[0].getClass());
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            for (Object entity : entities) {
                session.load(entity, (Serializable)EntityHelper.getValueId(entity));
            }
            session.flush();
            utx.commit();
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public Object lookup(Class entity, Object id) throws DAOException {
        Object obj = null;
        Session session = this.getSession(entity);
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            obj = this.getSession(entity).load(entity, (Serializable)id);
            session.flush();
            utx.commit();
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return obj;
    }

    @Override
    public void delete(Object ... entities) throws DAOException {
        if (entities == null) {
            throw new IllegalArgumentException("Entidade para dele\u00e7\u00e3o n\u00e3o pode ser null");
        }
        if (entities.length <= 0) {
            throw new IllegalArgumentException("Nenhuma Entidade foi informada para dele\u00e7\u00e3o");
        }
        Session session = this.getSession(entities[0].getClass());
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            for (Object entity : entities) {
                session.load(entity, (Serializable)EntityHelper.getValueId(entity));
                session.delete(entity);
            }
            session.flush();
            utx.commit();
        }
        catch (ConstraintViolationException ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex.getMessages()[ex.getMessages().length - 1], ex);
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    @Override
    public List query(String oqlCommand, int StartIndex, int MaxObjects, Object ... parameters) throws DAOException {
        OQL oql;
        Session session;
        List list = null;
        if (EntityHelper.getNamedQuery(this.getEntity(), oqlCommand) != null) {
            session = this.getSession(oqlCommand);
            oql = new OQL(EntityHelper.getNamedQuery(oqlCommand));
        } else {
            oql = new OQL(oqlCommand);
            session = this.getSession(oql.getClassBaseName());
        }
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            String select = oql.getOQLCommand();
            Query q = session.createQuery(select);
            String[] queryParams = oql.getParamNames();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (queryParams.length == 0) {
                        q.setParameter(i, parameters[i]);
                        continue;
                    }
                    q.setParameter(queryParams[i], parameters[i]);
                }
            }
            if (StartIndex > 0) {
                q.setFirstResult(StartIndex);
            }
            if (MaxObjects > 0) {
                q.setMaxResults(MaxObjects);
            }
            list = q.list();
            utx.commit();
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return list;
    }

    @Override
    public long queryCount(String oqlCommand, Object ... parameters) throws DAOException {
        Long count;
        Session session;
        OQL oql;
        if (EntityHelper.getNamedQuery(oqlCommand) != null) {
            oql = new OQL(EntityHelper.getNamedQuery(oqlCommand));
            session = this.getSession(oqlCommand);
        } else {
            oql = new OQL(oqlCommand);
            session = this.getSession(oql.getClassBaseName());
        }
        Transaction utx = session.getTransaction();
        try {
            utx.begin();
            Query query = session.createQuery(oql.getOQLCountCommand());
            String[] queryParams = oql.getParamNames();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (queryParams.length == 0) {
                        query.setParameter(i, parameters[i]);
                        continue;
                    }
                    query.setParameter(queryParams[i], parameters[i]);
                }
            }
            count = (Long)query.uniqueResult();
            utx.commit();
        }
        catch (Exception ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        return count;
    }

    @Override
    public Object getDelegate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int executeUpdate(String oqlCommand, Object ... parameters) throws DAOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        HibernateUtil.init();
    }
}

