/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.hibernate;

import entities.EntityException;
import entities.dao.DAOFactory;
import entities.util.EntityHelper;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import util.reflection.ClassHelper;

public final class HibernateUtil {
    private static final Logger log = Logger.getLogger(HibernateUtil.class.getName());
    private static final Map<String, SessionFactory> sessionFactorys = new LinkedHashMap<String, SessionFactory>();
    private static final Map<String, SessionFactory> classMetadatas = new LinkedHashMap<String, SessionFactory>();

    public static void init() {
    }

    private HibernateUtil() {
    }

    public static Session getSession(Class entity) {
        return HibernateUtil.getSession(entity.getName());
    }

    public static Session getSession(String metadata) {
        SessionFactory sessionFactory = classMetadatas.get(metadata);
        if (sessionFactory == null) {
            throw new EntityException("<" + metadata + "> n\u00e3o mapeado!");
        }
        return sessionFactory.getCurrentSession();
    }

    private static void loadConfigFiles() throws URISyntaxException {
        if (DAOFactory.getInstance().getMapFiles().size() > 0) {
            for (String mapFileName : DAOFactory.getInstance().getMapFiles()) {
                HibernateUtil.addConfigFile(mapFileName, mapFileName);
            }
        } else {
            HibernateUtil.addConfigFile("hibernate.cfg.xml", "hibernate.cfg.xml");
        }
    }

    private static void addConfigFile(String fileName, String key) {
        try {
            Object[] classes;
            SessionFactory sessionFactory = new AnnotationConfiguration().configure(fileName).buildSessionFactory();
            sessionFactorys.put(key, sessionFactory);
            for (Object object : classes = sessionFactory.getAllClassMetadata().keySet().toArray()) {
                String[] namedQueries;
                String className = object.toString();
                classMetadatas.put(className, sessionFactory);
                if (className.contains(".")) {
                    String[] split = className.split("\\.");
                    classMetadatas.put(split[split.length - 1], sessionFactory);
                }
                for (String namedQuery : namedQueries = EntityHelper.getNamedQueries(ClassHelper.getClass(className))) {
                    classMetadatas.put(namedQuery, sessionFactory);
                }
            }
            log.info("Arquivo de mapeamento : " + key + " adicionado.");
        }
        catch (HibernateException hex) {
            log.warning("Arquivo de mapeamento : " + key + " N\u00c3O FOI adicionado.");
            hex.printStackTrace();
        }
        catch (Exception exp) {
            log.warning("Arquivo de mapeamento : " + key + " N\u00c3O FOI adicionado.");
            exp.printStackTrace();
        }
    }

    static {
        try {
            HibernateUtil.loadConfigFiles();
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "Erro importando arquivos de configura\u00e7\u00e3o do hibernate", ex);
            ex.printStackTrace();
        }
    }
}

