/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.hibernate.dialects;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.Type;

public abstract class AbstractDialect
extends Dialect {
    private static final String LOCAL_DEFAULT_BATCH_SIZE = "15";
    private static final String LOCAL_NO_BATCH = "0";

    public AbstractDialect() {
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)Hibernate.INTEGER));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil", (Type)Hibernate.INTEGER));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees", (Type)Hibernate.DOUBLE));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)Hibernate.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)Hibernate.INTEGER));
        this.registerFunction("int", (SQLFunction)new StandardSQLFunction("int", (Type)Hibernate.INTEGER));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)Hibernate.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)Hibernate.DOUBLE));
        this.registerFunction("log2", (SQLFunction)new StandardSQLFunction("log2", (Type)Hibernate.DOUBLE));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)Hibernate.DOUBLE));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)Hibernate.INTEGER));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)Hibernate.DOUBLE));
        this.registerFunction("pow", (SQLFunction)new StandardSQLFunction("pow", (Type)Hibernate.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)Hibernate.DOUBLE));
        this.registerFunction("padians", (SQLFunction)new StandardSQLFunction("padians", (Type)Hibernate.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians", (Type)Hibernate.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round", (Type)Hibernate.INTEGER));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)Hibernate.DOUBLE));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc", (Type)Hibernate.DOUBLE));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate", (Type)Hibernate.DOUBLE));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)Hibernate.DOUBLE));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)Hibernate.DOUBLE));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)Hibernate.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)Hibernate.DOUBLE));
        this.registerFunction("crc32", (SQLFunction)new StandardSQLFunction("crc32", (Type)Hibernate.LONG));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)Hibernate.DOUBLE));
        this.registerFunction("alltrim", (SQLFunction)new StandardSQLFunction("alltrim"));
        this.registerFunction("asc", (SQLFunction)new StandardSQLFunction("asc", (Type)Hibernate.INTEGER));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)Hibernate.INTEGER));
        this.registerFunction("at", (SQLFunction)new StandardSQLFunction("at", (Type)Hibernate.INTEGER));
        this.registerFunction("bin", (SQLFunction)new StandardSQLFunction("bin", (Type)Hibernate.STRING));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)Hibernate.LONG));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)Hibernate.LONG));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)Hibernate.LONG));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)Hibernate.STRING));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("char", (Type)Hibernate.STRING));
        this.registerFunction("chrtran", (SQLFunction)new StandardSQLFunction("chrtran", (Type)Hibernate.STRING));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("concat_ws", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("conv", (SQLFunction)new StandardSQLFunction("conv", (Type)Hibernate.STRING));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)Hibernate.STRING));
        this.registerFunction("hex", (SQLFunction)new StandardSQLFunction("hex", (Type)Hibernate.STRING));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap"));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)Hibernate.INTEGER));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase"));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)Hibernate.INTEGER));
        this.registerFunction("len", (SQLFunction)new StandardSQLFunction("len", (Type)Hibernate.LONG));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)Hibernate.LONG));
        this.registerFunction("locate", (SQLFunction)new StandardSQLFunction("locate", (Type)Hibernate.LONG));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)Hibernate.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim"));
        this.registerFunction("mid", (SQLFunction)new StandardSQLFunction("mid", (Type)Hibernate.STRING));
        this.registerFunction("oct", (SQLFunction)new StandardSQLFunction("oct", (Type)Hibernate.STRING));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)Hibernate.LONG));
        this.registerFunction("padc", (SQLFunction)new StandardSQLFunction("padc", (Type)Hibernate.STRING));
        this.registerFunction("padl", (SQLFunction)new StandardSQLFunction("padl", (Type)Hibernate.STRING));
        this.registerFunction("padr", (SQLFunction)new StandardSQLFunction("padr", (Type)Hibernate.STRING));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction("position", (Type)Hibernate.INTEGER));
        this.registerFunction("proper", (SQLFunction)new StandardSQLFunction("proper"));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)Hibernate.STRING));
        this.registerFunction("replicate", (SQLFunction)new StandardSQLFunction("replicate", (Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)Hibernate.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)Hibernate.INTEGER));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)Hibernate.STRING));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim"));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex"));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)Hibernate.STRING));
        this.registerFunction("strcat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("strcmp", (SQLFunction)new StandardSQLFunction("strcmp", (Type)Hibernate.INTEGER));
        this.registerFunction("strconv", (SQLFunction)new StandardSQLFunction("strconv", (Type)Hibernate.STRING));
        this.registerFunction("strtran", (SQLFunction)new StandardSQLFunction("strtran", (Type)Hibernate.STRING));
        this.registerFunction("stuff", (SQLFunction)new StandardSQLFunction("stuff", (Type)Hibernate.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("stuff", (Type)Hibernate.STRING));
        this.registerFunction("substring", (SQLFunction)new StandardSQLFunction("substring", (Type)Hibernate.STRING));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)Hibernate.STRING));
        this.registerFunction("trim", (SQLFunction)new StandardSQLFunction("trim"));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase"));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("charmirr", (SQLFunction)new StandardSQLFunction("charmirr"));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse"));
        this.registerFunction("addtime", (SQLFunction)new StandardSQLFunction("addtime", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("cdow", (SQLFunction)new StandardSQLFunction("cdow", (Type)Hibernate.STRING));
        this.registerFunction("cmonth", (SQLFunction)new StandardSQLFunction("cmonth", (Type)Hibernate.STRING));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)Hibernate.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)Hibernate.TIME));
        this.registerFunction("date", (SQLFunction)new StandardSQLFunction("date", (Type)Hibernate.DATE));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)Hibernate.INTEGER));
        this.registerFunction("datetime", (SQLFunction)new NoArgSQLFunction("datetime", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("date_add", (SQLFunction)new StandardSQLFunction("date_add", (Type)Hibernate.DATE));
        this.registerFunction("date_sub", (SQLFunction)new StandardSQLFunction("date_sub", (Type)Hibernate.DATE));
        this.registerFunction("adddate", (SQLFunction)new StandardSQLFunction("adddate", (Type)Hibernate.DATE));
        this.registerFunction("subdate", (SQLFunction)new StandardSQLFunction("subdate", (Type)Hibernate.DATE));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)Hibernate.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)Hibernate.STRING));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)Hibernate.INTEGER));
        this.registerFunction("extract", (SQLFunction)new StandardSQLFunction("extract", (Type)Hibernate.INTEGER));
        this.registerFunction("dow", (SQLFunction)new StandardSQLFunction("dow", (Type)Hibernate.STRING));
        this.registerFunction("from_days", (SQLFunction)new StandardSQLFunction("from_days", (Type)Hibernate.DATE));
        this.registerFunction("gomonth", (SQLFunction)new StandardSQLFunction("gomonth", (Type)Hibernate.DATE));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)Hibernate.INTEGER));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day", (Type)Hibernate.DATE));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)Hibernate.INTEGER));
        this.registerFunction("millisecond", (SQLFunction)new StandardSQLFunction("millisecond", (Type)Hibernate.INTEGER));
        this.registerFunction("microsecond", (SQLFunction)new StandardSQLFunction("microsecond", (Type)Hibernate.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)Hibernate.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)Hibernate.STRING));
        this.registerFunction("now", (SQLFunction)new NoArgSQLFunction("now", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)Hibernate.INTEGER));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)Hibernate.INTEGER));
        this.registerFunction("sub_time", (SQLFunction)new NoArgSQLFunction("sub_time", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("sysdate", (SQLFunction)new NoArgSQLFunction("sysdate", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("time", (SQLFunction)new StandardSQLFunction("time", (Type)Hibernate.TIME));
        this.registerFunction("timediff", (SQLFunction)new StandardSQLFunction("timediff", (Type)Hibernate.TIME));
        this.registerFunction("timestamp", (SQLFunction)new StandardSQLFunction("timestamp", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)Hibernate.INTEGER));
        this.registerFunction("to_days", (SQLFunction)new StandardSQLFunction("to_days", (Type)Hibernate.INTEGER));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)Hibernate.INTEGER));
        this.registerFunction("weekofyear", (SQLFunction)new StandardSQLFunction("weekofyear", (Type)Hibernate.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)Hibernate.INTEGER));
        this.registerFunction("empty", (SQLFunction)new StandardSQLFunction("empty", (Type)Hibernate.BOOLEAN));
        this.registerFunction("isblank", (SQLFunction)new StandardSQLFunction("isblank", (Type)Hibernate.BOOLEAN));
        this.registerFunction("isalpha", (SQLFunction)new StandardSQLFunction("isalpha", (Type)Hibernate.BOOLEAN));
        this.registerFunction("isdigit", (SQLFunction)new StandardSQLFunction("isdigit", (Type)Hibernate.BOOLEAN));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull", (Type)Hibernate.BOOLEAN));
        this.registerFunction("cbool", (SQLFunction)new StandardSQLFunction("cbool", (Type)Hibernate.BOOLEAN));
        this.registerFunction("cbyte", (SQLFunction)new StandardSQLFunction("cbyte", (Type)Hibernate.BYTE));
        this.registerFunction("cdate", (SQLFunction)new StandardSQLFunction("cdate", (Type)Hibernate.DATE));
        this.registerFunction("cdbl", (SQLFunction)new StandardSQLFunction("cdbl", (Type)Hibernate.DOUBLE));
        this.registerFunction("cint", (SQLFunction)new StandardSQLFunction("cint", (Type)Hibernate.INTEGER));
        this.registerFunction("clng", (SQLFunction)new StandardSQLFunction("clng", (Type)Hibernate.LONG));
        this.registerFunction("csng", (SQLFunction)new StandardSQLFunction("csng", (Type)Hibernate.FLOAT));
        this.registerFunction("cstr", (SQLFunction)new StandardSQLFunction("cstr", (Type)Hibernate.STRING));
        this.registerFunction("ctod", (SQLFunction)new StandardSQLFunction("ctod", (Type)Hibernate.DATE));
        this.registerFunction("ctot", (SQLFunction)new StandardSQLFunction("ctot", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("dtoc", (SQLFunction)new StandardSQLFunction("dtoc", (Type)Hibernate.STRING));
        this.registerFunction("dtot", (SQLFunction)new StandardSQLFunction("dtot", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("ttoc", (SQLFunction)new StandardSQLFunction("ttoc", (Type)Hibernate.STRING));
        this.registerFunction("ttod", (SQLFunction)new StandardSQLFunction("ttod", (Type)Hibernate.DATE));
        this.registerFunction("compress", (SQLFunction)new StandardSQLFunction("compress", (Type)Hibernate.STRING));
        this.registerFunction("uncompress", (SQLFunction)new StandardSQLFunction("uncompress", (Type)Hibernate.STRING));
        this.registerFunction("encrypt", (SQLFunction)new StandardSQLFunction("encrypt", (Type)Hibernate.STRING));
        this.registerFunction("decrypt", (SQLFunction)new StandardSQLFunction("decrypt", (Type)Hibernate.STRING));
        this.registerFunction("encode", (SQLFunction)new StandardSQLFunction("encode", (Type)Hibernate.STRING));
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction("decode", (Type)Hibernate.STRING));
        this.registerFunction("md5", (SQLFunction)new StandardSQLFunction("md5", (Type)Hibernate.STRING));
        this.registerFunction("crypt3", (SQLFunction)new StandardSQLFunction("crypt3", (Type)Hibernate.STRING));
        this.registerFunction("database", (SQLFunction)new NoArgSQLFunction("database", (Type)Hibernate.STRING, false));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("user", (Type)Hibernate.STRING, false));
        this.registerFunction("deleted", (SQLFunction)new NoArgSQLFunction("deleted", (Type)Hibernate.BOOLEAN, false));
        this.registerFunction("reccount", (SQLFunction)new NoArgSQLFunction("reccount", (Type)Hibernate.LONG, false));
        this.registerFunction("recno", (SQLFunction)new NoArgSQLFunction("recno", (Type)Hibernate.LONG, false));
        this.registerFunction("rowlocked", (SQLFunction)new NoArgSQLFunction("rowlocked", (Type)Hibernate.BOOLEAN, false));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction("ifnull"));
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", LOCAL_DEFAULT_BATCH_SIZE);
    }

    public final boolean supportsSequences() {
        return true;
    }

    public boolean supportsPooledSequences() {
        return true;
    }

    public final String getSequenceNextValString(String sequenceName) {
        return "select " + this.getSelectSequenceNextValString(sequenceName);
    }

    public final String getSelectSequenceNextValString(String sequenceName) {
        return "nextval('" + sequenceName + "')";
    }

    public final String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public final String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public final String getQuerySequencesString() {
        return null;
    }

    public final boolean supportsLimit() {
        return true;
    }

    public final boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public final String getIdentitySelectString(String table, String column, int type) {
        return new StringBuffer().append("select currval('").append(table).append("','").append(column).append("')").toString();
    }

    public final String getIdentityColumnString() {
        return "not null auto_increment";
    }

    public final String getIdentityInsertString() {
        return "null";
    }

    public final boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public final boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public final boolean isCurrentTimestampSelectStringCallable() {
        return true;
    }

    public final String getCurrentTimestampSelectString() {
        return "select now()";
    }

    public final String getCurrentTimestampSQLFunctionName() {
        return "now";
    }

    public final boolean supportsUnionAll() {
        return true;
    }

    public final String getNoColumnsInsertString() {
        return "values ( )";
    }

    public final String toBooleanValueString(boolean bool) {
        return bool ? "true" : "false";
    }

    public final boolean dropConstraints() {
        return false;
    }

    public final boolean qualifyIndexName() {
        return false;
    }

    public final String getAddColumnString() {
        return "add column";
    }

    public final String getDropForeignKeyString() {
        throw new UnsupportedOperationException("No drop foreign key foreign supported by Hxtt Dialect");
    }

    public final String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    public final String getNullColumnString() {
        return " null";
    }

    public final boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public final boolean supportsColumnCheck() {
        return false;
    }

    public final boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public final boolean supportsRowValueConstructorSyntax() {
        return true;
    }

    public final boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    public final boolean useInputStreamToInsertBlob() {
        return false;
    }

    public final boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }
}

