/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.hibernate.dialects;

import entities.dao.hibernate.dialects.AbstractDialect;
import java.util.Locale;

public class ParadoxDialect
extends AbstractDialect {
    public ParadoxDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(1, "char(l)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(16, "boolean");
        this.registerColumnType(-5, "numeric(19,0)");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(-2, "binary");
        this.registerColumnType(-3, "varbinary");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerColumnType(1111, "currency");
        this.registerColumnType(1111, "graphics");
        this.registerColumnType(1111, "ole");
        this.registerColumnType(2000, "java_object");
    }

    public String getLimitString(String sql, boolean hasOffset) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (sql.toLowerCase(Locale.getDefault()).endsWith(" for update")) {
            sql = sql.substring(0, sql.length() - 11);
            isForUpdate = true;
        }
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, RECNO() rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where RECNO() <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where RECNO() <= ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        return pagingSelect.toString();
    }
}

