/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.jpa;

import entities.dao.AbstractDAO;
import entities.dao.DAOException;
import entities.dao.jpa.EntityManagerHelper;
import entities.dao.oql.OQL;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;

public class DAODefault
extends AbstractDAO {
    private EntityManager getEntityManager() {
        return EntityManagerHelper.getEM();
    }

    @Override
    public void beginTransaction() throws DAOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void save(Object ... entities) throws DAOException {
        EntityManager em = this.getEntityManager();
        EntityTransaction utx = em.getTransaction();
        try {
            utx.begin();
            for (Object entity : entities) {
                em.merge(entity);
            }
            em.flush();
            utx.commit();
        }
        catch (PersistenceException ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public void load(Object ... entities) {
        for (Object entity : entities) {
            this.getEntityManager().refresh(entity);
        }
    }

    @Override
    public Object lookup(Class entity, Object id) {
        return this.getEntityManager().find(entity, id);
    }

    @Override
    public void delete(Object ... entities) throws DAOException {
        EntityManager em = this.getEntityManager();
        EntityTransaction utx = em.getTransaction();
        try {
            utx.begin();
            if (entities != null) {
                for (Object entity : entities) {
                    em.remove(entity);
                }
            }
            em.flush();
            utx.commit();
        }
        catch (PersistenceException ex) {
            if (utx != null && utx.isActive()) {
                utx.rollback();
            }
            throw new DAOException(ex);
        }
        finally {
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public List query(String oqlCommand, int StartIndex, int MaxObjects, Object ... parameters) {
        OQL oql = new OQL(oqlCommand);
        String select = oql.getOQLCommand();
        EntityManager em = this.getEntityManager();
        Query q = em.createQuery(select);
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                q.setParameter(i, parameters[i]);
            }
        }
        if (StartIndex > 0) {
            q.setFirstResult(StartIndex);
        }
        if (MaxObjects > 0) {
            q.setMaxResults(MaxObjects);
        }
        return q.getResultList();
    }

    @Override
    public long queryCount(String oqlCommand, Object ... parameters) {
        OQL oql = new OQL(oqlCommand);
        EntityManager em = this.getEntityManager();
        Query query = em.createQuery(oql.getOQLCountCommand());
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
        }
        return (Long)query.getSingleResult();
    }

    @Override
    public Object getDelegate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int executeUpdate(String oqlCommand, Object ... parameters) throws DAOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

