/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.oql;

import entities.descriptor.IPropertyDescriptor;
import entities.descriptor.PropertyType;
import java.io.Serializable;

public class Filter
implements Serializable {
    private static final String ASTERISC = "*";
    private static final String APOSTROFE = "'";
    private static final String PERCENT = "%";
    private static final String[] OPERATORS = new String[]{"*", ">=", "<=", "<>", "=", ">", "<"};
    private String criteria = null;
    private final String propertyName;
    private final String alias;
    private boolean isQuoted = true;
    private final Object paramValue;

    public Filter(IPropertyDescriptor property, Object paramValue) {
        this.propertyName = property.getName();
        this.alias = property.getValue("ContextName") != null && !property.getValue("ContextName").toString().isEmpty() ? property.getValue("ContextName") + "." : "";
        if (property.getPropertyType().equals((Object)PropertyType.INTEGER) || property.getPropertyType().equals((Object)PropertyType.NUMERIC) || property.getPropertyType().equals((Object)PropertyType.BOOLEAN)) {
            this.isQuoted = false;
        }
        this.paramValue = paramValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getParamValue() {
        if (this.paramValue instanceof String) {
            return null;
        }
        return this.paramValue;
    }

    public String toString() {
        if (this.criteria == null) {
            this.criteria = "";
            if (this.paramValue instanceof String) {
                String[] values;
                boolean first = true;
                for (String value : values = this.paramValue.toString().split(";")) {
                    if (first) {
                        first = false;
                    } else {
                        this.criteria = this.criteria + " Or ";
                    }
                    this.criteria = this.criteria + this.convertExpression(value);
                }
                if (values.length > 1) {
                    this.criteria = "(" + this.criteria + ")";
                }
            } else {
                this.criteria = this.alias + this.propertyName + " = :" + this.propertyName;
            }
        }
        return this.criteria;
    }

    private String quote(String expression) {
        if (this.isQuoted) {
            return this.quote(expression, APOSTROFE);
        }
        return this.quote(expression, "");
    }

    private String quote(String expression, String quoteChar) {
        String newExpression = expression.startsWith(quoteChar) && expression.endsWith(quoteChar) ? expression : quoteChar + expression + quoteChar;
        return newExpression;
    }

    private String convertExpression(String value) {
        String newValue = "";
        String expression = this.alias + this.propertyName + " = " + this.quote(value);
        String[] ranger = value.split(" a ");
        if (ranger.length == 2) {
            expression = this.alias + this.propertyName + " Between " + this.quote(ranger[0]) + " and " + this.quote(ranger[1]);
        } else if (value.contains(ASTERISC)) {
            newValue = this.quote(value.replace(ASTERISC, PERCENT));
            expression = this.alias + this.propertyName + " Like " + newValue;
        } else {
            for (String signal : OPERATORS) {
                if (!value.startsWith(signal)) continue;
                newValue = value.replace(signal, "");
                if (ASTERISC.equals(signal)) {
                    newValue = this.quote(this.quote(newValue, PERCENT));
                }
                newValue = this.quote(newValue);
                expression = this.alias + this.propertyName + " " + signal + " " + newValue;
                break;
            }
        }
        return expression;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return !(this.propertyName == null ? other.getPropertyName() != null : !this.propertyName.equals(other.getPropertyName()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        return hash;
    }
}

