/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.oql;

import entities.EntityException;
import entities.dao.hibernate.HibernateUtil;
import entities.dao.oql.Filter;
import entities.dao.oql.Select;
import entities.descriptor.EntityDescriptorFactory;
import entities.descriptor.IDescriptor;
import entities.descriptor.IPropertyDescriptor;
import entities.util.EntityHelper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.reflection.ClassHelper;

public class OQL
implements Serializable {
    private static final String CONTEXT_NAME = "ContextName";
    private static final String FETCH_ALL_PROPERTIES = " fetch all properties";
    private static final String FROM = "From ";
    private static final String ORDER_BY = " Order By ";
    private static final String WHERE = " Where ";
    private String classBaseName;
    private String classResultName;
    private String selectCommand;
    private String whereCommand = " Where ";
    private String fromCommand = "From ";
    private String orderCommand;
    private final Set<Filter> filters = new LinkedHashSet<Filter>();
    private final Map<String, Boolean> sorters = new LinkedHashMap<String, Boolean>();
    private final Map<String, Object> params = new HashMap<String, Object>();
    private String alias = "";

    public OQL(Class clazz) {
        this(FROM + clazz.getName() + FETCH_ALL_PROPERTIES);
    }

    public OQL(String expression) {
        Select select;
        if (EntityHelper.getNamedQuery(expression) != null) {
            expression = EntityHelper.getNamedQuery(expression);
        }
        if (expression.split(" ").length == 1) {
            expression = FROM.concat(expression).concat(" o ").concat(FETCH_ALL_PROPERTIES);
        }
        if (!(select = new Select(expression)).ok()) {
            throw new IllegalArgumentException("A express\u00e3o " + expression + " n\u00e3o \u00e9 v\u00e1lida");
        }
        this.selectCommand = select.getSelectPart();
        this.fromCommand = " " + select.getFromPart();
        this.whereCommand = " " + select.getWherePart();
        this.orderCommand = " " + select.getOrderByPart();
        this.classResultName = select.getFields().entrySet().iterator().next().getKey();
        this.classBaseName = select.getClasses().entrySet().iterator().next().getKey();
        try {
            this.alias = select.getClasses().entrySet().iterator().next().getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OQL addFilter(String propertyName, Object propertyValue) {
        Class classe = ClassHelper.getClass(this.classBaseName);
        IDescriptor prop = EntityDescriptorFactory.getDescriptor(classe, propertyName);
        prop.setValue(CONTEXT_NAME, this.alias);
        if (prop == null) {
            throw new EntityException(propertyName + " n\u00e3o existe na classe " + this.classBaseName);
        }
        this.filters.add(new Filter((IPropertyDescriptor)prop, propertyValue));
        return this;
    }

    public void setParam(String paramName, Object value) {
        this.params.put(paramName, value);
    }

    public OQL addSort(String propertyName, boolean ascendent) {
        if (propertyName != null && !propertyName.equals("")) {
            this.sorters.put(propertyName, ascendent);
        }
        return this;
    }

    public OQL clear() {
        this.filters.clear();
        this.sorters.clear();
        return this;
    }

    private String evalOQL() {
        String oql = this.getSelect() + this.getFrom() + this.getWhere() + this.getOrderBy();
        return oql.trim();
    }

    private String getSelect() {
        if (this.selectCommand == null) {
            this.selectCommand = "";
        }
        return this.selectCommand;
    }

    private String getFrom() {
        return this.fromCommand;
    }

    private String getWhere() {
        StringBuffer where = new StringBuffer("");
        for (Filter filter : this.filters) {
            if (filter.toString().equals("")) continue;
            if (where.toString().isEmpty()) {
                where.append(this.whereCommand);
            }
            if (!where.toString().equals(WHERE)) {
                where.append(" And ");
            }
            where.append(filter.toString());
        }
        if (where.toString().isEmpty() && !this.whereCommand.equals(WHERE)) {
            where = new StringBuffer(this.whereCommand);
        }
        return where.toString();
    }

    private String getOrderBy() {
        boolean first = true;
        StringBuffer orderBy = new StringBuffer();
        for (Map.Entry<String, Boolean> entry : this.sorters.entrySet()) {
            if (first) {
                orderBy.append(ORDER_BY);
                first = false;
            } else {
                orderBy.append(", ");
            }
            orderBy.append(entry.getKey() + (entry.getValue() != false ? "" : " DESC"));
        }
        if (orderBy.toString().isEmpty() && !this.orderCommand.equals(ORDER_BY)) {
            orderBy = new StringBuffer(this.orderCommand);
        }
        return orderBy.toString();
    }

    public String getOQLCommand() {
        return this.evalOQL();
    }

    public String getOQLCountCommand() {
        return this.changeToCount(this.evalOQL());
    }

    private String changeToCount(String oql) {
        int startIndex = oql.toLowerCase(Locale.getDefault()).indexOf("from ");
        int endIndex = oql.toLowerCase(Locale.getDefault()).indexOf(" order by ");
        if (endIndex == -1) {
            endIndex = oql.length();
        }
        String select = this.selectCommand.isEmpty() ? "*" : this.selectCommand.replace("Select ", "");
        return "Select count(" + select + ") " + oql.substring(startIndex, endIndex).replaceAll("fetch all properties", " ").replaceAll(" fetch ", " ");
    }

    public String getClassBaseName() {
        return this.classBaseName;
    }

    public String getClassResultName() {
        return this.classResultName;
    }

    public Map<String, Object> getParams() {
        LinkedHashMap<String, Object> returnParams = new LinkedHashMap<String, Object>();
        for (String propertyName : this.getParamNames()) {
            returnParams.put(propertyName, this.params.get(propertyName));
        }
        for (Filter filter : this.filters) {
            if (filter.getParamValue() == null) continue;
            returnParams.put(filter.getPropertyName(), filter.getParamValue());
        }
        return returnParams;
    }

    public String[] getParamNames() {
        Pattern pattern = Pattern.compile(":\\w*");
        Matcher matcher = pattern.matcher(this.evalOQL());
        LinkedList<String> linkedParams = new LinkedList<String>();
        while (matcher.find()) {
            linkedParams.add(matcher.group().substring(1));
        }
        return linkedParams.toArray(new String[linkedParams.size()]);
    }

    static {
        HibernateUtil.init();
    }
}

