/*
 * Decompiled with CFR 0.152.
 */
package entities.dao.oql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Select {
    private String consulta;
    private String consultaBase;
    private Map<String, String> tbClasses;
    private Map<String, String> tbCampos;
    private static Map<String, String> tb = new HashMap<String, String>();
    private boolean semSelect;
    private boolean soUmCampo;

    public Select(String consulta) {
        this.consulta = consulta;
        this.analisa();
    }

    public boolean ok() {
        return this.tbClasses != null && this.tbCampos != null;
    }

    public String getQuery() {
        return this.consulta;
    }

    public String getSimplifiedQuery() {
        return this.consultaBase;
    }

    public String getSimplifiedSelectPart() {
        return this.consultaBase.replaceAll(Select.prepara("\\s*<FROM>\\s+.*$"), "").replaceAll("\\s\\s*", " ").trim();
    }

    public String getSimplifiedFromPart() {
        return this.consultaBase.substring(this.getSelectPart().length()).trim();
    }

    public String getSelectPart() {
        return this.semSelect ? "" : this.normaliza(this.consulta.replaceAll(Select.prepara("<FROM>\\s+.*$"), ""));
    }

    public String getFromPart() {
        if (this.soUmCampo) {
            return "From " + this.consulta.trim();
        }
        String r = this.consulta.replaceAll(Select.prepara("<FROM>\\s+.*$"), "");
        return this.normaliza(this.consulta.substring(r.length()).replaceAll(Select.prepara("<WHERE>\\s+.*$"), "").replaceAll(Select.prepara("<ORDERBY>\\s+.*$"), ""));
    }

    public String getWherePart() {
        String r = this.consulta.replaceAll(Select.prepara("<WHERE>\\s+.*$"), "");
        String t = this.consulta.substring(r.length()).trim();
        String s = this.normaliza(t.replaceAll(Select.prepara("<ORDERBY>\\s+.*$"), ""));
        return s.isEmpty() ? "Where " : s;
    }

    public String getOrderByPart() {
        String r = this.consulta.replaceAll(Select.prepara("<ORDERBY>\\s+.*$"), "");
        String s = this.normaliza(this.consulta.substring(r.length()));
        return s.isEmpty() ? "Order By " : s;
    }

    public Map<String, String> getClasses() {
        return this.tbClasses;
    }

    public String[] getFieldsNames() {
        Set<String> s = this.tbCampos.keySet();
        return this.tbCampos != null ? s.toArray(new String[s.size()]) : null;
    }

    public Map<String, String> getFields() {
        return this.tbCampos;
    }

    private void analisa() {
        List<String> lst;
        boolean NADA = false;
        boolean SELECT = true;
        int FROM = 2;
        int WHERE = 3;
        Object ret = null;
        this.consultaBase = this.normaliza(this.consulta.replaceAll(Select.prepara("<FETCHALLPROPS>"), "").replaceAll(Select.prepara("(?:<LEFT>\\s+)?(?:<INNER>\\s+)?(?:<OUTER>\\s+)?<JOIN>\\s+(?:<FETCH>\\s+)?[\\w\\.]+"), "").replaceAll(Select.prepara("<WHERE>\\s+.*$"), "").replaceAll(Select.prepara("<ORDERBY>\\s+.*$"), ""));
        if ((this.consultaBase.matches(Select.prepara("(<SELECT>.*<CAMPOS>)?.*<FROM>.*<CLASSES>")) || this.consultaBase.matches(Select.prepara("<NOME>"))) && (lst = this.separa()) != null) {
            LinkedHashMap<String, String> tbSelect = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> tbFrom = new LinkedHashMap<String, String>();
            int status = 0;
            for (String s : lst) {
                switch (status) {
                    case 0: {
                        if (!"select".equalsIgnoreCase(s)) break;
                        status = 1;
                        break;
                    }
                    case 1: {
                        if ("from".equalsIgnoreCase(s)) {
                            status = 2;
                            break;
                        }
                        if (s.toLowerCase().startsWith("new")) {
                            this.poeCampo(s.substring(4), "");
                            break;
                        }
                        String[] ww = s.split(Select.prepara("\\s+(?:<AS>\\s+)?"));
                        String a = ww.length == 2 ? ":" + ww[1] : "";
                        String[] ss = ww[0].split("\\s*\\.\\s*");
                        if (ss.length > 1) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = 1; i < ss.length; ++i) {
                                sb.append(sb.length() > 0 ? "." : "").append(ss[i]);
                            }
                            tbSelect.put(ss[1] + a, ss[0]);
                            break;
                        }
                        tbSelect.put(ss[0] + a, "?");
                        break;
                    }
                    case 2: {
                        if ("where".equalsIgnoreCase(s)) {
                            status = 3;
                            break;
                        }
                        String[] ss = s.split(Select.prepara("\\s+(?:<AS>\\s+)?"));
                        if (ss.length == 2) {
                            tbFrom.put(ss[1], ss[0]);
                            this.poeClasse(ss[0], ss[1]);
                        } else {
                            tbFrom.put("?", ss[0]);
                            this.poeClasse(ss[0], "");
                        }
                        if (!this.semSelect) break;
                        this.poeCampo(ss[0], "");
                    }
                }
            }
            for (String campo : tbSelect.keySet()) {
                String w = (String)tbSelect.get(campo);
                String v = (String)tbFrom.get(w);
                String[] z = campo.split(":");
                if (!"?".equals(w)) {
                    this.poeCampo(v + "." + z[0], z.length == 2 ? z[1] : "");
                    continue;
                }
                if (v != null) {
                    if (campo.equals(v)) {
                        this.poeCampo(z[0], z.length == 2 ? z[1] : "");
                        continue;
                    }
                    this.poeCampo(v + "." + z[0], z.length == 2 ? z[1] : "");
                    continue;
                }
                this.poeCampo((String)tbFrom.get(campo), z.length == 2 ? z[1] : "");
            }
        }
    }

    private void poeClasse(String classe, String alias) {
        if (classe != null && !classe.startsWith("null")) {
            if (this.tbClasses == null) {
                this.tbClasses = new LinkedHashMap<String, String>();
            }
            this.tbClasses.put(classe, alias);
        }
    }

    private void poeCampo(String campo, String alias) {
        if (campo != null && !campo.startsWith("null")) {
            if (this.tbCampos == null) {
                this.tbCampos = new LinkedHashMap<String, String>();
            }
            this.tbCampos.put(campo, alias);
        }
    }

    private List<String> separa() {
        int j;
        Matcher m2;
        String w;
        int i;
        ArrayList<String> lst = null;
        Matcher m = Pattern.compile(Select.prepara("<SELECT>(\\s+<DISTINCT>)?\\s+(.*)\\s+<FROM>.*")).matcher(this.consultaBase);
        if (m.find()) {
            if (lst == null) {
                lst = new ArrayList<String>();
            }
            lst.add("select");
            for (i = 1; i <= m.groupCount(); ++i) {
                w = m.group(i);
                if (w == null) continue;
                if (w.toLowerCase().startsWith("new")) {
                    w = w.replaceAll(Select.prepara("\\(.*\\)"), "").trim();
                    lst.add(w);
                    continue;
                }
                m2 = Pattern.compile(Select.prepara("<CAMPO>")).matcher(w);
                while (m2.find()) {
                    for (j = 1; j <= m2.groupCount(); ++j) {
                        if (m2.group(j) == null) continue;
                        lst.add(m2.group(j));
                    }
                }
            }
        }
        if ((m = Pattern.compile(Select.prepara("<FROM>\\s+(.*)")).matcher(this.consultaBase)).find()) {
            if (lst == null) {
                this.semSelect = true;
                lst = new ArrayList();
                lst.add("select");
            }
            lst.add("from");
            for (i = 1; i <= m.groupCount(); ++i) {
                w = m.group(i);
                if (w == null) continue;
                m2 = Pattern.compile(Select.prepara("<CLASSE>")).matcher(w);
                while (m2.find()) {
                    for (j = 1; j <= m2.groupCount(); ++j) {
                        if (m2.group(j) == null) continue;
                        lst.add(m2.group(j));
                    }
                }
            }
            lst.add("where");
        }
        if (lst == null && (m = Pattern.compile(Select.prepara("<NOME>")).matcher(this.consultaBase)).find()) {
            this.semSelect = true;
            this.soUmCampo = true;
            lst = new ArrayList();
            lst.add("select");
            lst.add(m.group());
            lst.add("from");
            lst.add(m.group());
        }
        return lst;
    }

    private static String prepara(String texto) {
        if (tb.isEmpty()) {
            tb.put("<SELECT>", "\\b[Ss][Ee][Ll][Ee][Cc][Tt]\\b");
            tb.put("<DISTINCT>", "\\b[Dd][Ii][Ss][Tt][Ii][Nn][Cc][Tt]\\b");
            tb.put("<FROM>", "\\b[Ff][Rr][Oo][Mm]\\b");
            tb.put("<WHERE>", "\\b[Ww][Hh][Ee][Rr][Ee]\\b");
            tb.put("<ORDERBY>", "\\b[Oo][Rr][Dd][Ee][Rr]\\s+[Bb][Yy]\\b");
            tb.put("<AS>", "\\b[Aa][Ss]\\b");
            tb.put("<AND>", "\\b[Aa][Nn][Dd]\\b");
            tb.put("<OR>", "\\b[Oo][Rr]\\b");
            tb.put("<NEW>", "\\b[Nn][Ee][Ww]\\b");
            tb.put("<ALL>", "\\b[Aa][Ll][Ll]\\b");
            tb.put("<PROPERTIES>", "\\b[Pp][Rr][Oo][Pp][Ee][Rr][Tt][Ii][Ee][Ss]\\b");
            tb.put("<FETCH>", "\\b[Ff][Ee][Tt][Cc][Hh]\\b");
            tb.put("<FETCHALLPROPS>", Select.prepara("<FETCH>\\s+<ALL>\\s+<PROPERTIES>"));
            tb.put("<INNER>", "\\b[Ii][Nn][Nn][Ee][Rr]\\b");
            tb.put("<OUTER>", "\\b[Oo][Uu][Tt][Ee][Rr]\\b");
            tb.put("<JOIN>", "\\b[Jj][Oo][Ii][Nn]\\b");
            tb.put("<LEFT>", "\\b[Ll][Ee][Ff][Tt]\\b");
            tb.put("<RIGHT>", "\\b[Rr][Ii][Gg][Hh][Tt]\\b");
            tb.put("<NOME>", "\\b(?:\\w+(?:\\.\\w+)*)|(?:'\\?')\\b");
            tb.put("<LISTA>", Select.prepara("(?:<NOME>(?:,(?:<NOME>))*)"));
            tb.put("<CAMPOSIMPLES>", Select.prepara("((?:<NOME>)(?:\\s+(?:<AS>\\s+)?\\w+)?)"));
            tb.put("<CAMPONEW>", Select.prepara("(?:<NEW>)\\s+(?:<NOME>)\\((?:<LISTA>)?\\)"));
            tb.put("<CAMPO>", Select.prepara("(?:<CAMPONEW>|<CAMPOSIMPLES>)"));
            tb.put("<CLASSE>", Select.prepara("((?:<NOME>)(?:\\s+(?:<AS>\\s+)?\\w+)?)"));
            tb.put("<CAMPOS>", Select.prepara("(?:<CAMPO>)(?:,<CAMPO>)*"));
            tb.put("<CLASSES>", Select.prepara("(?:<CLASSE>)(?:,<CLASSE>)*"));
        }
        for (String s : tb.keySet()) {
            texto = texto.replace(s, tb.get(s));
        }
        return texto;
    }

    private String normaliza(String s) {
        String w = s.replaceAll("\\s*\\.\\s*", ".").replaceAll("\\s*\\,\\s*", ",").replaceAll("\\s\\s*", " ").replaceAll(Select.prepara("<SELECT>"), "Select").replaceAll(Select.prepara("<DISTINCT>"), "Distinct").replaceAll(Select.prepara("<FROM>"), "From").replaceAll(Select.prepara("\\s+<WHERE>"), " Where").replaceAll(Select.prepara("^<WHERE>"), " Where").replaceAll(Select.prepara("<ORDERBY>"), "Order By").replaceAll(Select.prepara("<AND>"), "And").replaceAll(Select.prepara("<OR>"), "Or").trim();
        return w;
    }
}

