/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import entities.annotations.ActionDescriptor;
import entities.annotations.ParameterDescriptor;
import entities.descriptor.IActionDescriptor;
import entities.descriptor.IDescriptor;
import java.beans.FeatureDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.persistence.TemporalType;
import util.convert.ConvertNames;
import util.convert.I18N;
import util.jsf.IType;
import util.jsf.Types;
import util.reflection.ClassHelper;

public class ActionDescriptorWrapper
extends FeatureDescriptor
implements IActionDescriptor {
    private Integer index = -1;
    private Integer subIndex = -1;
    private String value = "";
    private String image = "";
    private IType componentType = Types.COMMAND_BUTTON;
    private String methodDisabled = "";
    private String methodRendered = "";
    private boolean confirm = false;
    private String confirmMessage = "";
    private boolean immediate = false;
    private Class<?> beanType = null;
    private boolean hasParams = false;
    private Boolean readOnly = false;
    private Boolean writeOnly = false;

    public ActionDescriptorWrapper(Method method) {
        this.beanType = method.getDeclaringClass();
        this.setHidden(false);
        this.setName(method.getName());
        this.setDisplayName(ConvertNames.naturalName(method.getName()));
        this.value = this.getDisplayName();
        if (method.isAnnotationPresent(ActionDescriptor.class)) {
            ActionDescriptor descriptor = method.getAnnotation(ActionDescriptor.class);
            this.setIndex(descriptor.index());
            this.setDisplayName(descriptor.displayName());
            this.setShortDescription(descriptor.shortDescription());
            this.componentType = descriptor.componenteType();
            if (!descriptor.value().isEmpty()) {
                this.value = I18N.isKey(descriptor.value()) ? I18N.getMessage(descriptor.value(), this.getDisplayName(), new Object[0]) : descriptor.value();
            }
            if (!descriptor.image().isEmpty()) {
                this.image = descriptor.image();
            }
            if (!descriptor.methodDisabled().isEmpty()) {
                this.methodDisabled = descriptor.methodDisabled();
            }
            if (!descriptor.methodRendered().isEmpty()) {
                this.methodRendered = descriptor.methodRendered();
            }
            this.confirm = descriptor.confirm();
            if (descriptor.confirm()) {
                this.confirmMessage = descriptor.confirmMessage().isEmpty() ? "Confirma?" : (I18N.isKey(descriptor.confirmMessage()) ? I18N.getMessage(descriptor.confirmMessage(), "Confirma?", new Object[0]) : descriptor.confirmMessage());
            }
            this.immediate = descriptor.immediate();
            this.setHidden(descriptor.hidden());
        }
        int i = 0;
        Annotation[][] annotations = method.getParameterAnnotations();
        for (Class<?> paramType : method.getParameterTypes()) {
            this.hasParams = true;
            int scale = 0;
            int precision = 0;
            String displayName = "Par\u00e2metro " + i;
            TemporalType temporalType = DEFAULT_TEMPORAL_TYPE;
            ParameterDescriptor desc = null;
            if (annotations[i] != null && annotations[i].length > 0 && annotations[i][0] != null) {
                desc = (ParameterDescriptor)annotations[i][0];
                displayName = desc.displayName();
                temporalType = desc.temporal();
            }
            if (desc == null || desc.scale() == 0 && desc.precision() == 0) {
                if (ClassHelper.isInteger(paramType)) {
                    scale = 6;
                    precision = 0;
                } else if (ClassHelper.isDecimal(paramType)) {
                    scale = 8;
                    precision = 2;
                }
            } else if (ClassHelper.isNumber(paramType)) {
                scale = desc.scale();
                precision = desc.precision();
            }
            this.setValue("arg" + i, paramType);
            this.setValue("displayName" + i, displayName);
            this.setValue("scale" + i, scale);
            this.setValue("precision" + i, precision);
            this.setValue("temporalType" + i, temporalType);
            ++i;
        }
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public Integer getSubIndex() {
        return this.subIndex;
    }

    @Override
    public void setSubIndex(Integer subIndex) {
        this.subIndex = subIndex;
    }

    @Override
    public IType getComponentType() {
        return this.componentType;
    }

    @Override
    public void setComponentType(IType type) {
        this.componentType = type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getImageURL() {
        return this.image;
    }

    @Override
    public String getMethodDisabled() {
        return this.methodDisabled;
    }

    @Override
    public void setMethodDisabled(String methodDisabled) {
        this.methodDisabled = methodDisabled;
    }

    @Override
    public String getMethodRendered() {
        return this.methodRendered;
    }

    @Override
    public void setMethodRendered(String methodRendered) {
        this.methodRendered = methodRendered;
    }

    @Override
    public boolean isConfirm() {
        return this.confirm;
    }

    @Override
    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    @Override
    public String getConfirmMessage() {
        return this.confirmMessage;
    }

    @Override
    public void setConfirmMessage(String message) {
        this.confirmMessage = message;
    }

    @Override
    public boolean isImmediate() {
        return this.immediate;
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    @Override
    public Boolean isFilterable() {
        return false;
    }

    @Override
    public Boolean isOrderable() {
        return false;
    }

    @Override
    public Boolean isSummary() {
        return true;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.getValue("readOnly") != null) {
            this.readOnly = (Boolean)this.getValue("readOnly");
        }
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Boolean isWriteOnly() {
        if (this.getValue("writeOnly") != null) {
            this.writeOnly = (Boolean)this.getValue("writeOnly");
        }
        return this.writeOnly;
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    public int compareTo(Object object) {
        int result = 0;
        IDescriptor prop = (IDescriptor)object;
        result = this.getIndex().equals(prop.getIndex()) ? this.getSubIndex() - prop.getSubIndex() : this.getIndex() - prop.getIndex();
        return result;
    }

    @Override
    public IActionDescriptor clone() {
        try {
            return (IActionDescriptor)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.toString());
        }
    }

    public Class getBeanType() {
        return this.beanType;
    }
}

