/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import entities.descriptor.ActionDescriptorWrapper;
import entities.descriptor.DescriptorException;
import entities.descriptor.EntityDescriptorWrapper;
import entities.descriptor.IDescriptor;
import entities.descriptor.IEntityDescriptor;
import entities.descriptor.IPropertyDescriptor;
import entities.descriptor.PropertyDescriptorWrapper;
import entities.descriptor.PropertyType;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import util.reflection.ClassHelper;
import util.reflection.MethodHelper;
import util.reflection.PropertyHelper;
import util.reflection.ReflectionException;

public final class EntityDescriptorFactory {
    private EntityDescriptorFactory() {
    }

    public static IEntityDescriptor createEntityDescriptor(Object objectOrClass) {
        EntityDescriptorWrapper edw = null;
        BeanDescriptor beanDescriptor = null;
        Class type = ClassHelper.getClass(objectOrClass);
        try {
            beanDescriptor = Introspector.getBeanInfo(type).getBeanDescriptor();
            edw = new EntityDescriptorWrapper(type, beanDescriptor);
        }
        catch (IntrospectionException ex) {
            throw new DescriptorException(ex);
        }
        return edw;
    }

    public static Map<String, IDescriptor> createDescriptors(Object clazzType) {
        LinkedHashMap<String, IDescriptor> descriptor = new LinkedHashMap<String, IDescriptor>();
        List<IDescriptor> props = EntityDescriptorFactory.createPropertyDescriptors(clazzType);
        for (IDescriptor prop : props) {
            descriptor.put(prop.getName(), prop);
        }
        List<Method> methlist = MethodHelper.getMethods(clazzType);
        for (int i = 0; i < methlist.size(); ++i) {
            Method method = methlist.get(i);
            descriptor.put(method.getName() + "()", new ActionDescriptorWrapper(method));
        }
        return descriptor;
    }

    public static IDescriptor getDescriptor(Class<?> type, String propertyName) {
        String[] propNames = propertyName.split("\\.");
        Class<?> nestedType = type;
        FeatureDescriptor descriptor = null;
        PropertyDescriptor prop = null;
        block2: for (int i = 0; i < propNames.length; ++i) {
            String nestedPropName = propNames[i];
            if (nestedPropName.endsWith("()")) {
                Method method = MethodHelper.getMethod(nestedType, nestedPropName.replace("()", ""));
                if (method == null) {
                    throw new DescriptorException("Propriedade <" + nestedPropName + "> n\u00e3o encontrada na classe " + type.getCanonicalName());
                }
                descriptor = new ActionDescriptorWrapper(method);
                descriptor.setName(propertyName.replace("()", ""));
                continue;
            }
            for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors(nestedType)) {
                if (!propDescriptor.getName().equals(nestedPropName)) continue;
                prop = propDescriptor;
                if (i < propNames.length - 1) {
                    if (prop.getPropertyType().toString().contains(".Collection") || prop.getPropertyType().toString().contains(".List") || prop.getPropertyType().toString().contains(".Set")) {
                        nestedType = (Class<?>)PropertyHelper.getPropertyGenericType(nestedType, nestedPropName);
                        continue block2;
                    }
                    nestedType = prop.getPropertyType();
                    continue block2;
                }
                try {
                    descriptor = new PropertyDescriptorWrapper(nestedType, prop);
                    descriptor.setName(propertyName);
                    continue block2;
                }
                catch (IntrospectionException ex) {
                    throw new DescriptorException(ex);
                }
            }
        }
        if (descriptor == null) {
            throw new DescriptorException("Propriedade <" + propertyName + "> n\u00e3o encontrada na classe " + type.getCanonicalName());
        }
        return descriptor;
    }

    @Deprecated
    public static List<IDescriptor> createPropertyDescriptors(Object objectOrClass) {
        LinkedList<IDescriptor> props = new LinkedList<IDescriptor>();
        Class entity = ClassHelper.getClass(objectOrClass);
        for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors((Class)entity)) {
            if (propDescriptor.getName().equals("class")) continue;
            try {
                PropertyDescriptorWrapper pdw = new PropertyDescriptorWrapper(entity, propDescriptor);
                if (pdw.getPropertyType().equals((Object)PropertyType.ENTITY_EMBEDDED)) {
                    List<IPropertyDescriptor> embeddeds = EntityDescriptorFactory.getNestedPropertyDescriptors(pdw.getName(), pdw.getPropertyClass());
                    for (IPropertyDescriptor prop : embeddeds) {
                        prop.setSubIndex(prop.getIndex());
                        prop.setIndex(pdw.getIndex());
                        props.add(prop);
                    }
                    continue;
                }
                props.add(pdw);
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException(ex);
            }
        }
        Collections.sort(props);
        return props;
    }

    @Deprecated
    public static List<IDescriptor> createPropertyDescriptors(Object objectOrClass, List<String> propertiesNames) {
        LinkedList<IDescriptor> props = new LinkedList<IDescriptor>();
        Class entity = ClassHelper.getClass(objectOrClass);
        for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors((Class)entity)) {
            if (!propertiesNames.contains(propDescriptor.getName())) continue;
            try {
                PropertyDescriptorWrapper pdw = new PropertyDescriptorWrapper(entity, propDescriptor);
                pdw.setIndex(propertiesNames.indexOf(propDescriptor.getName()));
                if (pdw.getPropertyType().equals((Object)PropertyType.ENTITY_EMBEDDED)) {
                    List<IPropertyDescriptor> embeddeds = EntityDescriptorFactory.getNestedPropertyDescriptors(pdw.getName(), pdw.getPropertyClass());
                    for (IPropertyDescriptor prop : embeddeds) {
                        prop.setSubIndex(prop.getIndex());
                        prop.setIndex(pdw.getIndex());
                        props.add(prop);
                    }
                    continue;
                }
                props.add(pdw);
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException(ex);
            }
        }
        Collections.sort(props);
        return props;
    }

    public static List<IPropertyDescriptor> getNestedPropertyDescriptors(String nestedPropertyName, Class clazzType) {
        LinkedList<IPropertyDescriptor> props = new LinkedList<IPropertyDescriptor>();
        for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors((Class)clazzType)) {
            if (propDescriptor.getName().equals("class")) continue;
            try {
                PropertyDescriptorWrapper pdw = new PropertyDescriptorWrapper(clazzType, propDescriptor);
                String name = nestedPropertyName + "." + pdw.getName().substring(pdw.getName().lastIndexOf(".") + 1);
                pdw.setName(name);
                if (pdw.getPropertyType().equals((Object)PropertyType.ENTITY_EMBEDDED)) {
                    props.addAll(EntityDescriptorFactory.getNestedPropertyDescriptors(pdw.getName(), pdw.getPropertyClass()));
                    continue;
                }
                props.add(pdw);
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException(ex);
            }
        }
        Collections.sort(props);
        return props;
    }
}

