/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import entities.annotations.EntityDescriptor;
import entities.descriptor.IEntityDescriptor;
import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import util.convert.ConvertNames;
import util.convert.I18N;

public class EntityDescriptorWrapper
extends FeatureDescriptor
implements IEntityDescriptor {
    private static final String KEY_ENTITY_NAME = "entity.%s.displayName";
    private static final String KEY_ENTITY_PLURAL = "entity.%s.pluralDisplayName";
    private static final String KEY_ENTITY_SHORT = "entity.%s.shortDescription";
    private Class<?> entityType;
    private Class<?> customizerType;
    private String pluralDisplayName;
    private String shortDescription;
    private String displayName;

    public EntityDescriptorWrapper(Class entityType, BeanDescriptor beanDesriptor) {
        this.entityType = entityType;
        this.setName(beanDesriptor.getName());
        this.setDisplayName(beanDesriptor.getDisplayName());
        this.setDisplayName(ConvertNames.naturalName(beanDesriptor.getName()));
        this.setExpert(beanDesriptor.isExpert());
        this.setHidden(beanDesriptor.isHidden());
        this.setPreferred(beanDesriptor.isPreferred());
        this.setShortDescription(beanDesriptor.getShortDescription());
        this.setPluralDisplayName(ConvertNames.plural(beanDesriptor.getName()));
        if (entityType.isAnnotationPresent(EntityDescriptor.class)) {
            EntityDescriptor prop = entityType.getAnnotation(EntityDescriptor.class);
            this.setHidden(prop.hidden());
            if (!prop.displayName().isEmpty()) {
                this.setDisplayName(prop.displayName());
            }
            this.setHidden(prop.hidden());
            this.setDisplayName(prop.displayName());
            this.setPluralDisplayName(prop.pluralDisplayName());
        }
    }

    @Override
    public String getDisplayName() {
        String key = String.format(KEY_ENTITY_NAME, this.entityType.getCanonicalName());
        return I18N.getMessage(key, this.displayName, new Object[0]);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getPluralDisplayName() {
        String key = String.format(KEY_ENTITY_PLURAL, this.entityType.getCanonicalName());
        return I18N.getMessage(key, this.pluralDisplayName, new Object[0]);
    }

    @Override
    public void setPluralDisplayName(String pluralDisplayName) {
        this.pluralDisplayName = pluralDisplayName;
    }

    @Override
    public String getShortDescription() {
        String key = String.format(KEY_ENTITY_SHORT, this.entityType.getCanonicalName());
        return I18N.getMessage(key, this.shortDescription, new Object[0]);
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityType;
    }

    @Override
    public void setEntityClass(Class<?> bean) {
        this.entityType = bean;
    }

    @Override
    public Class<?> getCustomizerClass() {
        return this.customizerType;
    }

    @Override
    public void setCustomizerClass(Class<?> bean) {
        this.customizerType = bean;
    }

    @Override
    public Integer getIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setIndex(Integer index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Integer getSubIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSubIndex(Integer subIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean isFilterable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean isOrderable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean isSummary() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean isReadOnly() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean isWriteOnly() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int compareTo(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Class getBeanType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

