/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import entities.annotations.Editor;
import entities.annotations.PropertyDescriptor;
import entities.descriptor.DescriptorException;
import entities.descriptor.IDescriptor;
import entities.descriptor.IPropertyDescriptor;
import entities.descriptor.PropertyType;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.validator.Digits;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;
import util.convert.ConvertNames;
import util.convert.I18N;
import util.reflection.ClassHelper;

public final class PropertyDescriptorWrapper
extends FeatureDescriptor
implements IPropertyDescriptor {
    private Field field;
    private PropertyType propertyType;
    private String displayName;
    private Integer displayWidth = 30;
    private Integer displayRows = 1;
    private String shortDescription;
    private Integer index = -1;
    private Integer subIndex = 0;
    private Class beanType;
    private Boolean filterable = false;
    private Boolean orderable = false;
    private Boolean required = false;
    private Boolean readOnly = false;
    private Boolean writeOnly = false;
    private Boolean summary = true;
    private Boolean secret = false;
    private Boolean identifier = false;
    private GenerationType generationType;
    private Class<?> propertyClass;
    private Integer precision;
    private Integer scale;
    private String format;
    private String regex;

    public PropertyDescriptorWrapper(Class entityType, java.beans.PropertyDescriptor propertyDesriptor) throws IntrospectionException {
        Column column;
        this.field = ClassHelper.getField(entityType, propertyDesriptor.getName());
        this.beanType = entityType;
        this.propertyClass = propertyDesriptor.getPropertyType();
        try {
            BeanUtils.copyProperties((Object)this, (Object)propertyDesriptor);
        }
        catch (Exception e) {
            throw new DescriptorException(e);
        }
        this.setDisplayName(ConvertNames.naturalName(this.getName()));
        this.setShortDescription(ConvertNames.naturalName(propertyDesriptor.getShortDescription()));
        String returnTypeName = this.propertyClass.getSimpleName().toLowerCase();
        if (this.propertyClass.equals(String.class)) {
            if (this.field.isAnnotationPresent(Lob.class)) {
                this.displayRows = 5;
                this.propertyType = PropertyType.MEMO;
            } else {
                this.propertyType = PropertyType.TEXT;
            }
            if (this.field.isAnnotationPresent(Column.class)) {
                this.displayWidth = this.field.getAnnotation(Column.class).length();
            }
        } else if (returnTypeName.startsWith("byte[]") || this.field.isAnnotationPresent(Lob.class) || returnTypeName.equals("uploadedfile") || returnTypeName.equals("file") || returnTypeName.equals("inputstream")) {
            this.propertyType = PropertyType.BLOB;
            this.displayWidth = 15;
        } else if (ClassHelper.isInteger(this.propertyClass)) {
            this.propertyType = PropertyType.INTEGER;
            this.scale = 6;
            this.precision = 0;
            this.displayWidth = 10;
        } else if (ClassHelper.isDecimal(this.propertyClass)) {
            this.propertyType = PropertyType.NUMERIC;
            this.scale = 8;
            this.precision = 2;
            this.displayWidth = 10;
        } else if (returnTypeName.startsWith("date") || returnTypeName.startsWith("calendar")) {
            if (this.field.isAnnotationPresent(Temporal.class)) {
                TemporalType type = this.field.getAnnotation(Temporal.class).value();
                if (type.equals((Object)TemporalType.DATE)) {
                    this.format = "dd/MM/yyyy";
                    this.propertyType = PropertyType.DATE;
                } else if (type.equals((Object)TemporalType.TIME)) {
                    this.format = "HH:mm:ss";
                    this.propertyType = PropertyType.TIME;
                } else if (type.equals((Object)TemporalType.TIMESTAMP)) {
                    this.format = "dd/MM/yyyy HH:mm:ss";
                    this.propertyType = PropertyType.DATETIME;
                }
                this.displayWidth = this.format.length();
            } else {
                this.format = "dd/MM/yyyy";
                this.propertyType = PropertyType.DATE;
                this.displayWidth = this.format.length();
            }
        } else if (returnTypeName.startsWith("bool")) {
            this.propertyType = PropertyType.BOOLEAN;
        } else if (returnTypeName.startsWith("collection") || returnTypeName.startsWith("list") || returnTypeName.startsWith("set")) {
            this.propertyType = PropertyType.COLLECTION;
            this.displayWidth = 3;
        } else if (this.propertyClass.isEnum()) {
            this.propertyType = PropertyType.ENUM;
            this.displayWidth = 15;
        } else {
            this.propertyType = this.field.isAnnotationPresent(Embedded.class) || this.field.isAnnotationPresent(EmbeddedId.class) ? PropertyType.ENTITY_EMBEDDED : (this.field.isAnnotationPresent(ManyToOne.class) ? PropertyType.ENTITY_MANY_TO_ONE : (this.field.isAnnotationPresent(OneToOne.class) ? PropertyType.ENTITY_ONE_TO_ONE : (this.field.isAnnotationPresent(ManyToMany.class) ? PropertyType.ENTITY_MANY_TO_MANY : PropertyType.TEXT)));
        }
        this.required = this.field.isAnnotationPresent(NotNull.class) || this.field.isAnnotationPresent(NotEmpty.class) || this.field.isAnnotationPresent(Column.class) && !this.field.getAnnotation(Column.class).nullable();
        if (this.field.isAnnotationPresent(Column.class) && ((column = this.field.getAnnotation(Column.class)).scale() > 0 || column.precision() > 0)) {
            this.precision = column.precision();
            this.scale = column.scale();
            this.displayWidth = column.precision() + column.scale() + 1;
        }
        if (this.field.isAnnotationPresent(Digits.class)) {
            Digits digits = this.field.getAnnotation(Digits.class);
            this.scale = digits.integerDigits();
            this.precision = digits.fractionalDigits();
            this.displayWidth = digits.integerDigits() + digits.fractionalDigits() + 1;
        }
        if (this.field.isAnnotationPresent(Pattern.class)) {
            this.regex = this.field.getAnnotation(Pattern.class).regex();
        }
        this.identifier = this.field.isAnnotationPresent(Id.class) || this.field.isAnnotationPresent(EmbeddedId.class);
        if (this.field.isAnnotationPresent(GeneratedValue.class)) {
            GeneratedValue gType = this.field.getAnnotation(GeneratedValue.class);
            this.generationType = gType.strategy();
        }
        if (this.field.isAnnotationPresent(PropertyDescriptor.class)) {
            PropertyDescriptor prop = this.field.getAnnotation(PropertyDescriptor.class);
            if (!prop.displayName().isEmpty()) {
                this.setDisplayName(prop.displayName());
            }
            if (!prop.shortDescription().isEmpty()) {
                this.setShortDescription(prop.shortDescription());
            }
            if (prop.displayWidth() > 0) {
                this.setDisplayWidth(prop.displayWidth());
            }
            this.setIndex(prop.index());
            this.setSecret(prop.secret());
            this.setHidden(prop.hidden());
            this.setSummary(prop.summary());
            this.setReadOnly(prop.readOnly());
            this.setOrderable(prop.autoSort());
            this.setFilterable(prop.autoFilter());
            this.setDisplayRows(prop.displayRows());
        }
        if (this.field.isAnnotationPresent(Editor.class)) {
            Editor editor = this.field.getAnnotation(Editor.class);
            if (!editor.propertyType().equals((Object)PropertyType.DEFAULT)) {
                this.propertyType = editor.propertyType();
            }
            if (!editor.inputComponentName().isEmpty()) {
                this.setValue("inputComponentName", editor.inputComponentName());
            }
            if (!editor.outputComponentName().isEmpty()) {
                this.setValue("outputComponentName", editor.outputComponentName());
            }
            if (editor.inputComponentProperties().length > 0) {
                this.setValue("inputComponentParams", editor.inputComponentProperties());
            }
            if (editor.outputComponentProperties().length > 0) {
                this.setValue("outputComponentParams", editor.outputComponentProperties());
            }
            if (!editor.namedQuery().isEmpty()) {
                this.setValue("namedQuery", editor.namedQuery());
            }
        }
    }

    @Override
    public Class getPropertyClass() {
        return this.propertyClass;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public Integer getSubIndex() {
        return this.subIndex;
    }

    @Override
    public void setSubIndex(Integer subIndex) {
        this.subIndex = subIndex;
    }

    @Override
    public Boolean isRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
    }

    @Override
    public Boolean isIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Boolean identifier) {
        this.identifier = identifier;
    }

    @Override
    public Boolean isSummary() {
        return this.summary;
    }

    public void setSummary(Boolean summary) {
        this.summary = summary;
    }

    public Class getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class beanType) {
        this.beanType = beanType;
    }

    @Override
    public boolean isSecret() {
        return this.secret;
    }

    public void setSecret(Boolean secret) {
        this.secret = secret;
    }

    @Override
    public GenerationType getIdGeneratedType() {
        return this.generationType;
    }

    @Override
    public Integer getPrecision() {
        return this.precision;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public String getDisplayFormat() {
        return this.format;
    }

    @Override
    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
    }

    @Override
    public String getRegex() {
        return this.regex;
    }

    @Override
    public int getDisplayRows() {
        return this.displayRows;
    }

    public void setDisplayRows(int displayRows) {
        this.displayRows = displayRows;
    }

    @Override
    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    private void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    private void setOrderable(Boolean orderable) {
        this.orderable = orderable;
    }

    @Override
    public Boolean isFilterable() {
        return this.filterable;
    }

    @Override
    public Boolean isOrderable() {
        return this.orderable;
    }

    @Override
    public String getDisplayName() {
        Object[] args = new Object[]{this.getBeanType().getCanonicalName(), this.getName()};
        String key = String.format("entity.%s.%s.displayName", args);
        return I18N.getMessage(key, this.displayName, new Object[0]);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getShortDescription() {
        Object[] args = new Object[]{this.getBeanType().getCanonicalName(), this.getName()};
        String key = String.format("entity.%s.%s.shortDescription", args);
        return I18N.getMessage(key, this.shortDescription, new Object[0]);
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public Boolean isReadOnly() {
        if (this.identifier.booleanValue() && this.generationType != null && !this.generationType.equals((Object)GenerationType.IDENTITY)) {
            return true;
        }
        if (this.getValue("readOnly") != null) {
            this.readOnly = (Boolean)this.getValue("readOnly");
        }
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Boolean isWriteOnly() {
        if (this.getValue("writeOnly") != null) {
            this.writeOnly = (Boolean)this.getValue("writeOnly");
        }
        return this.writeOnly;
    }

    @Override
    public Type getPropertyGenericType() {
        Type returnType = null;
        try {
            if (this.field.getGenericType() instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)this.field.getGenericType();
                Type[] types = type.getActualTypeArguments();
                returnType = types[0];
            }
        }
        catch (ClassCastException ex) {
            throw new DescriptorException("Propriedade <" + this.getName() + "> n\u00e3o usa Generic!!", ex);
        }
        catch (SecurityException ex) {
            throw new DescriptorException(ex);
        }
        return returnType;
    }

    public int compareTo(Object object) {
        int result = 0;
        IDescriptor prop = (IDescriptor)object;
        result = this.getIndex().equals(prop.getIndex()) ? this.getSubIndex() - prop.getSubIndex() : this.getIndex() - prop.getIndex();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDescriptorWrapper other = (PropertyDescriptorWrapper)obj;
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }
}

