/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import javax.persistence.TemporalType;
import util.reflection.ClassHelper;

public enum PropertyType {
    TEXT,
    COLOR,
    MEMO,
    INTEGER,
    NUMERIC,
    BOOLEAN,
    DATE,
    TIME,
    DATETIME,
    BLOB,
    IMAGE,
    ENUM,
    COLLECTION,
    ENTITY_EMBEDDED,
    ENTITY_ONE_TO_ONE,
    ENTITY_MANY_TO_ONE,
    ENTITY_MANY_TO_MANY,
    DEFAULT;


    public static PropertyType converter(Class<?> propertyClass) {
        return PropertyType.converter(propertyClass, TemporalType.DATE);
    }

    public static PropertyType converter(Class<?> propertyClass, TemporalType temporalType) {
        PropertyType propertyType = null;
        String returnTypeName = propertyClass.getSimpleName().toLowerCase();
        if (propertyClass.equals(String.class)) {
            propertyType = TEXT;
        } else if (returnTypeName.startsWith("byte[]") || returnTypeName.equals("inputstream")) {
            propertyType = BLOB;
        } else if (ClassHelper.isInteger(propertyClass)) {
            propertyType = INTEGER;
        } else if (ClassHelper.isDecimal(propertyClass)) {
            propertyType = NUMERIC;
        } else if (returnTypeName.startsWith("date") || returnTypeName.startsWith("calendar")) {
            if (temporalType.equals((Object)TemporalType.DATE)) {
                propertyType = DATE;
            } else if (temporalType.equals((Object)TemporalType.TIME)) {
                propertyType = TIME;
            } else if (temporalType.equals((Object)TemporalType.TIMESTAMP)) {
                propertyType = DATETIME;
            }
        } else {
            propertyType = returnTypeName.startsWith("bool") ? BOOLEAN : (returnTypeName.startsWith("collection") || returnTypeName.startsWith("list") || returnTypeName.startsWith("set") ? COLLECTION : (propertyClass.isEnum() ? ENUM : TEXT));
        }
        return propertyType;
    }
}

