/*
 * Decompiled with CFR 0.152.
 */
package entities.descriptor;

import entities.EntityException;
import entities.annotations.Param;
import entities.annotations.View;
import entities.annotations.Views;
import entities.descriptor.DescriptorException;
import entities.descriptor.EntityDescriptorFactory;
import entities.descriptor.GroupDescriptor;
import entities.descriptor.IActionDescriptor;
import entities.descriptor.IDescriptor;
import entities.descriptor.IEntityDescriptor;
import entities.descriptor.IPropertyDescriptor;
import entities.descriptor.PropertyType;
import entities.descriptor.TableDescriptor;
import entities.gui.jsf.ActionController;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import util.jsf.JSFContextHelper;
import util.reflection.ClassHelper;

@Views(value={@View(name="CRUD", title="@View", filters="@View", header="Ctrl.DAO.create(),Ctrl.DAO.edit(),Ctrl.DAO.delete(),Ctrl.DAO.save(),Ctrl.DAO.cancel(),@View", members="Ctrl.DAO.selectRow(),@View", footer="@View"), @View(name="CRUD_PAGE", title="@View", filters="@View", header="Ctrl.DAO.create(),Ctrl.DAO.editPage(),Ctrl.DAO.deletePage(),Ctrl.DAO.savePage(),Ctrl.DAO.cancelPage(),@View", members="@View", footer="Ctrl.DAO.scroll(),@View", rows=1), @View(name="FILTER", title="@View", filters="Filtrar por[[@View],Ctrl.DAO.filter()]", header="@View", members="@View", footer="@View"), @View(name="PAGER", title="@View", filters="@View", header="@View", members="@View", footer="Ctrl.DAO.scroll(),@View", rows=10)})
public class ViewDescriptor {
    private static final String FORM = "FORM";
    private static final String TABLE = "TABLE";
    private static final String PREFIX_CONTROLLER = "Ctrl.";
    private Class<?> type;
    private String viewName = "";
    private String title = "";
    private String namedQuery = "";
    private int rows = 0;
    private String filters = "";
    private String header = "";
    private String body = "";
    private String footer = "";
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private Object filterDescriptors;
    private Object headerDescriptors;
    private Object bodyDescriptors;
    private Object footerDescriptors;
    private List<IActionDescriptor> actions = new ArrayList<IActionDescriptor>();
    private Map<String, IDescriptor> descriptors;
    private IEntityDescriptor descr;

    public ViewDescriptor() {
    }

    public ViewDescriptor(Object entity, String viewNameFull) {
        this.viewName = viewNameFull;
        this.type = ClassHelper.getClass(entity);
        this.descriptors = EntityDescriptorFactory.createDescriptors(entity);
        this.descr = EntityDescriptorFactory.createEntityDescriptor(this.type);
        this.update();
        boolean hasView = false;
        if (this.type.isAnnotationPresent(Views.class)) {
            Views descriptor = this.type.getAnnotation(Views.class);
            for (View view : descriptor.value()) {
                if (!view.name().equals(viewNameFull)) continue;
                hasView = true;
                this.title = view.title();
                this.filters = view.filters().trim();
                this.header = view.header().trim();
                this.body = view.members().trim();
                this.footer = view.footer().trim();
                this.namedQuery = view.namedQuery().isEmpty() ? this.type.getCanonicalName() : view.namedQuery();
                for (Param param : view.params()) {
                    this.params.put(param.name(), param.value());
                }
                this.rows = view.rows();
                if (view.template().isEmpty()) break;
                for (String template : view.template().split("\\+")) {
                    this.applyTemplate(template);
                }
                break;
            }
        }
        if (!hasView && viewNameFull != null) {
            String[] templates = viewNameFull.replace("TABLE_CRUD", "TABLE+@CRUD+@PAGER").replace("FORM_CRUD", "FORM+@CRUD_PAGE").concat(this.filters.isEmpty() ? "" : "+@FILTER").split("\\+");
            for (int i = 0; i < templates.length; ++i) {
                if (i == 0) {
                    if (templates[i].equals(FORM)) {
                        this.rows = 1;
                        this.body = this.descr.getDisplayName() + "[" + this.body.replace(",", ";") + "]";
                    } else if (!templates[i].equals(TABLE)) {
                        throw new DescriptorException("<" + viewNameFull + "> n\u00e3o encontrada na classe " + this.type.getCanonicalName());
                    }
                    hasView = true;
                    continue;
                }
                if (i <= 0) continue;
                this.applyTemplate(templates[i]);
            }
        }
        if (!hasView) {
            throw new DescriptorException("<" + viewNameFull + "> n\u00e3o encontrada na classe " + this.type.getCanonicalName());
        }
        this.header = this.header.replaceFirst("[,;]$", "").replaceFirst("^[,;]", "");
        this.body = this.body.replaceFirst("[,;]$", "").replaceFirst("^[,;]", "");
        this.footer = this.footer.replaceFirst("[,;]$", "").replaceFirst("^[,;]", "");
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public List<IActionDescriptor> getActions() {
        return this.actions;
    }

    public void setActions(List<IActionDescriptor> actions) {
        this.actions = actions;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public Object getFilterDescriptors() {
        if (this.filterDescriptors == null) {
            this.filterDescriptors = this.createViewDescriptors(this.type, this.filters, "filters");
        }
        return this.filterDescriptors;
    }

    public void setFilterDescriptors(Object filterDescriptors) {
        this.filterDescriptors = filterDescriptors;
    }

    public Object getBodyDescriptors() {
        if (this.bodyDescriptors == null) {
            if (this.body.isEmpty()) {
                String members = "";
                for (String member : this.descriptors.keySet()) {
                    members = members + (members.isEmpty() ? "" : ",") + member;
                }
                this.bodyDescriptors = this.createViewDescriptors(this.type, members, "members");
            } else {
                this.bodyDescriptors = this.createViewDescriptors(this.type, this.body, "body");
            }
        }
        return this.bodyDescriptors;
    }

    public Object getFooterDescriptors() {
        if (this.footerDescriptors == null) {
            this.footerDescriptors = this.createViewDescriptors(this.type, this.footer, "footer");
        }
        return this.footerDescriptors;
    }

    public Object getHeaderDescriptors() {
        if (this.headerDescriptors == null) {
            this.headerDescriptors = this.createViewDescriptors(this.type, this.header, "header");
        }
        return this.headerDescriptors;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object createViewDescriptors(Class<?> entity, String stringView, String facet) throws RuntimeException {
        IActionDescriptor actionDescriptor;
        void var4_11;
        void var4_12;
        stringView = stringView.trim();
        Object var4_4 = null;
        String[] aRows = ViewDescriptor.split(stringView, ';');
        if (aRows.length > 1) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (String subString : aRows) {
                list.add(this.createViewDescriptors(entity, subString, facet));
            }
            LinkedList<Object> linkedList = list;
            return var4_12;
        }
        if (aRows.length != 1) return var4_12;
        String[] cols = ViewDescriptor.split(stringView, ',');
        if (cols.length > 1) {
            int i = 0;
            Object[] array = new Object[cols.length];
            for (String subString : cols) {
                array[i++] = this.createViewDescriptors(entity, subString, facet);
            }
            Object[] objectArray = array;
            return var4_12;
        }
        if (cols.length != 1) return var4_12;
        stringView = cols[0];
        String displayName = null;
        boolean writeOnly = false;
        boolean readonly = false;
        if (stringView.startsWith("'") && stringView.contains("':")) {
            displayName = stringView.substring(stringView.indexOf("'"), stringView.indexOf("':"));
            stringView = stringView.substring(stringView.indexOf("':") + 2);
        }
        if (stringView.startsWith("#")) {
            writeOnly = true;
            stringView = stringView.substring(1);
        } else if (stringView.startsWith("*")) {
            readonly = true;
            stringView = stringView.substring(1);
        }
        int colspan = 0;
        try {
            if (stringView.contains(":")) {
                int index = stringView.lastIndexOf(":");
                colspan = Integer.valueOf(stringView.substring(index + 1));
                stringView = stringView.substring(0, index);
            }
        }
        catch (NumberFormatException nfex) {
            colspan = 0;
        }
        if (stringView.contains("{") && stringView.contains("}")) {
            throw new UnsupportedOperationException(stringView);
        }
        if (stringView.contains("[") && stringView.contains("]")) {
            String caption = stringView.substring(0, stringView.indexOf("["));
            String subString = stringView.substring(stringView.indexOf("[") + 1, stringView.lastIndexOf("]"));
            GroupDescriptor groupDescriptor = new GroupDescriptor(caption, this.createViewDescriptors(entity, subString, facet), colspan);
        } else if (stringView.contains("<") && stringView.contains(">")) {
            String collection = stringView.substring(0, stringView.indexOf("<"));
            String subString = stringView.substring(stringView.indexOf("<") + 1, stringView.lastIndexOf(">"));
            IPropertyDescriptor propDesc = (IPropertyDescriptor)EntityDescriptorFactory.getDescriptor(entity, collection);
            if (!propDesc.getPropertyType().equals((Object)PropertyType.COLLECTION)) {
                throw new RuntimeException("<" + collection + "> N\u00e3o \u00e9 propriedade do tipo Collection");
            }
            TableDescriptor table = new TableDescriptor(propDesc.getDisplayName());
            table.setColspan(colspan);
            table.setValue(collection);
            entity = (Class)propDesc.getPropertyGenericType();
            table.setObject(this.createViewDescriptors(entity, subString, facet));
            TableDescriptor tableDescriptor = table;
        } else if (stringView.startsWith(PREFIX_CONTROLLER)) {
            String ctrlName = stringView.split("\\.")[1];
            Object service = JSFContextHelper.getManagedBean(ctrlName);
            if (service == null) {
                throw new RuntimeException("controller n\u00e3o encontrado '" + stringView + "'");
            }
            if (!(service instanceof ActionController)) throw new RuntimeException("controller '" + ctrlName + "' n\u00e3o extend ActionController");
            String actionName = stringView.substring(ctrlName.length() + PREFIX_CONTROLLER.length() + 1);
            IDescriptor actionDesc = EntityDescriptorFactory.getDescriptor(service.getClass(), actionName);
            if (actionDesc == null) {
                throw new RuntimeException("'" + actionName + "' n\u00e3o existe em " + service.getClass().getCanonicalName());
            }
            actionDesc.setValue("ContextName", ctrlName);
            IDescriptor iDescriptor = actionDesc;
        } else {
            IDescriptor iDescriptor = EntityDescriptorFactory.getDescriptor(entity, stringView);
            if (iDescriptor == null) {
                throw new EntityException("Sintax erro em <" + stringView + ">");
            }
        }
        if (var4_11 instanceof IDescriptor) {
            IDescriptor descriptor = (IDescriptor)var4_11;
            descriptor.setValue("writeOnly", writeOnly);
            descriptor.setValue("readOnly", readonly);
            descriptor.setValue("facet", facet);
            if (displayName != null) {
                descriptor.setDisplayName(displayName);
            }
            if (colspan > 0) {
                descriptor.setValue("colspan", colspan);
            }
        }
        if (var4_11 instanceof IActionDescriptor && (actionDescriptor = (IActionDescriptor)var4_11).getValue("arg0") != null) {
            this.actions.add(actionDescriptor);
        }
        if (var4_11 != null) return var4_12;
        throw new EntityException("Member <" + stringView + "> n\u00e3o encontrado");
    }

    protected static String[] split(String string, char name) {
        LinkedList<String> list = new LinkedList<String>();
        int token = 0;
        String subString = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(' || string.charAt(i) == '[' || string.charAt(i) == '{' || string.charAt(i) == '<') {
                ++token;
            } else if (string.charAt(i) == ')' || string.charAt(i) == ']' || string.charAt(i) == '}' || string.charAt(i) == '>') {
                --token;
            }
            if (string.charAt(i) == name && token == 0) {
                list.add(subString);
                subString = "";
                continue;
            }
            subString = subString + string.charAt(i);
        }
        if (!subString.isEmpty()) {
            list.add(subString);
        }
        String[] split = list.toArray(new String[list.size()]);
        return split;
    }

    protected void applyTemplate(String templateName) {
        String tempBean = templateName.split("\\@")[0];
        String tempView = templateName.split("@")[1];
        if (tempBean.toString().isEmpty()) {
            tempBean = this.type.getCanonicalName();
        }
        ViewDescriptor template = null;
        try {
            template = new ViewDescriptor(tempBean, tempView);
        }
        catch (DescriptorException ex) {
            template = new ViewDescriptor(this.getClass().getCanonicalName(), tempView);
        }
        this.title = template.getTitle().replace("@View", this.title.trim()).replace(",,", ",").replace(",;", ";");
        this.filters = template.getFilters().replace("@View", this.filters.trim()).replace(",,", ",").replace(",;", ";");
        this.header = template.getHeader().replace("@View", this.header.trim()).replace(",,", ",").replace(",;", ";");
        this.body = template.getBody().replace("@View", this.body.trim()).replace(",,", ",").replace(",;", ";");
        this.footer = template.getFooter().replace("@View", this.footer.trim()).replace(",,", ",").replace(",;", ";");
        if (this.rows <= 0 && template.getRows() > 0) {
            this.rows = template.getRows();
        }
    }

    protected void update() {
        StringBuilder members = new StringBuilder("");
        String sep = ",";
        this.title = this.descr.getPluralDisplayName();
        this.namedQuery = this.type.getCanonicalName();
        int iFilters = 0;
        for (String member : this.descriptors.keySet()) {
            if (this.descriptors.get(member) instanceof IPropertyDescriptor && ((IPropertyDescriptor)this.descriptors.get(member)).getPropertyType().equals((Object)PropertyType.COLLECTION)) continue;
            if (!this.descriptors.get(member).isHidden()) {
                members.append((members.toString().isEmpty() ? "" : sep) + member);
            }
            if (!this.descriptors.get(member).isFilterable().booleanValue()) continue;
            String sepFilter = iFilters % 3 == 0 ? ";" : ",";
            this.filters = this.filters + (this.filters.toString().isEmpty() ? "" : sepFilter) + member;
            ++iFilters;
        }
        this.body = members.toString();
    }
}

