/*
 * Decompiled with CFR 0.152.
 */
package entities.faces.jsf;

import entities.dao.DAOConstraintException;
import entities.dao.DAOException;
import entities.dao.DAOFactory;
import entities.dao.DAOValidationException;
import entities.dao.IDAO;
import entities.dao.oql.OQL;
import entities.faces.jsf.DesignerJSF;
import entities.faces.jsf.INavigator;
import entities.util.EntityComparator;
import entities.util.EntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.model.KeepAlive;
import util.convert.I18N;
import util.jsf.BackBeanViewPage;
import util.jsf.ComponentFactory;
import util.jsf.Types;
import util.reflection.ClassHelper;
import util.reflection.ObjectHelper;

@Deprecated
@KeepAlive
public class EntityBackBean
extends BackBeanViewPage
implements INavigator {
    private static final String REQUEST_LIVE = "requestLive";
    private static final String ACTION_DELETE = "showActionDelete";
    private static final String ACTION_NEW = "showActionNew";
    private static final String ACTION_EDIT = "showActionEdit";
    private static final String ROWS_PER_PAGE = "rowsPerPage";
    private static final String ROWS_SELECT = "rowsSelect";
    public static final String SHOW_ROW_NUM = "showRowNum";
    private static final String SHOW_PROPERTIES = "showProperties";
    private static final String OQL = "oql";
    private IDAO dao;
    private Class<?> type;
    private List dataList;
    private Object dataItem;
    private Map<Object, Boolean> selectedIds = new HashMap<Object, Boolean>();
    private boolean editMode = false;
    private int addCount = 0;
    private ViewMode viewMode = ViewMode.TABLE;
    private transient UIComponentBase entityPanel;
    private transient UIData dataTable;
    private transient UIComponentBase autoForm;
    private Boolean requestLive = false;
    private Boolean showActionNew = true;
    private Boolean showActionEdit = true;
    private Boolean showActionDelete = true;
    private Boolean showRowNum = false;
    private String showProperties = null;
    private Integer rowsPerPage = 0;
    private Integer rowsSelect = 0;
    private transient OQL oql = null;

    private void actionLoad() {
        this.dataList = null;
        try {
            if (this.oql != null) {
                String query = null;
                if (this.oql.getOQLCommand().contains("@")) {
                    String[] split = this.oql.getOQLCommand().split("@");
                    Class clazz = ClassHelper.getClass(split[0]);
                    query = EntityHelper.getNamedQuery(clazz, split[1]);
                } else {
                    query = this.oql.getOQLCommand();
                }
                String[] oqlParamsNames = new OQL(query).getParamNames();
                LinkedList<Object> oqlParams = new LinkedList<Object>();
                for (String paramName : oqlParamsNames) {
                    if (this.getParams().containsKey(paramName)) {
                        oqlParams.add(this.getParams().get(paramName));
                        continue;
                    }
                    if (EntityBackBean.getSessionMapValue(paramName) != null) {
                        oqlParams.add(EntityBackBean.getSessionMapValue(paramName));
                        continue;
                    }
                    if (EntityBackBean.getApplicationMapValue(paramName) == null) continue;
                    oqlParams.add(EntityBackBean.getApplicationMapValue(paramName));
                }
                this.dataList = this.dao.query(this.oql.getOQLCommand(), oqlParams.toArray());
            }
        }
        catch (Exception e) {
            this.addErrorMessage(null, "actionLoad.errorMessage", "Ocurreu um erro inesperado : {0}", e.getMessage());
        }
    }

    public void actionRefresh() {
        this.actionLoad();
        this.setAddCount(0);
        this.editMode = false;
        this.selectedIds.clear();
        this.actionFirst();
        this.addInfoMessage(null, "actionRefresh.infoMessage", "Dados atualizados!", new Object[0]);
    }

    public void actionToggleSelectAll() {
        for (int i = 0; i < this.dataList.size(); ++i) {
            if (i < this.dataTable.getFirst() || i >= this.dataTable.getFirst() + this.dataTable.getRows()) continue;
            Object entity = this.dataList.get(i);
            Object key = EntityHelper.getValueId(entity);
            if (this.selectedIds.containsKey(key)) {
                this.selectedIds.put(key, this.selectedIds.get(key) == false);
                continue;
            }
            this.selectedIds.put(key, true);
        }
    }

    public void actionNew() {
        Object newItem = this.dao.newInstance(this.type);
        this.dataList.add(newItem);
        this.setAddCount(this.getAddCount() + 1);
        this.editMode = true;
        if (this.isFormView()) {
            this.dataItem = newItem;
        } else {
            this.actionLast();
        }
    }

    public void actionEdit() {
        List selectedItems = this.getSelectedDataList();
        boolean bl = this.editMode = !selectedItems.isEmpty();
        if (selectedItems.isEmpty()) {
            this.addWarnMessage(null, "actionEdit.warnMessage", "Selecione pelo menos um item para alterar", new Object[0]);
        }
    }

    public void actionSave() {
        ArrayList<Object> items = new ArrayList<Object>();
        if (this.dataItem != null) {
            items.add(this.dataItem);
        } else if (this.dataList != null) {
            for (Object item : this.dataList) {
                if (!this.isEditModeRow(item)) continue;
                items.add(item);
            }
        }
        if (!items.isEmpty()) {
            try {
                this.dao.save(items.toArray());
                this.setAddCount(0);
                this.editMode = false;
                this.selectedIds.clear();
                this.addInfoMessage(null, "actionSave.infoMessage", "{0} Item(ns) salvo(s) com sucesso!", items.size());
            }
            catch (DAOConstraintException exp) {
                this.addWarnMessage(null, "actionSave.warnMessage", exp.getMessage(), new Object[0]);
            }
            catch (DAOValidationException exp) {
                this.addWarnMessage(null, "actionSave.warnMessage", exp.getMessage(), new Object[0]);
            }
            catch (DAOException exp) {
                this.addErrorMessage(null, "actionSave.erroMessage", exp.getMessage(), new Object[0]);
            }
        }
    }

    public void actionCancel() {
        this.actionLoad();
        this.setAddCount(0);
        this.editMode = false;
        this.selectedIds.clear();
        this.actionFirst();
        this.addInfoMessage(null, "actionCancel.infoMessage", "As altera\u00e7\u00f5es foram canceladas", new Object[0]);
    }

    public void actionDelete() {
        List selectedItems = this.getSelectedDataList();
        if (selectedItems.isEmpty()) {
            this.addWarnMessage(null, "actionDelete.warnMessage", "Selecione pelo menos um item para excluir!", new Object[0]);
            return;
        }
        try {
            this.dao.delete(selectedItems.toArray());
            for (Object item : selectedItems) {
                this.dataList.remove(item);
            }
            this.addInfoMessage(null, "actionDelete.InfoMessage", "Exclus\u00e3o efetuada com sucesso!", new Object[0]);
        }
        catch (DAOConstraintException exp) {
            this.addWarnMessage(null, "actionDelete.warnMessage", exp.getMessage(), new Object[0]);
        }
        catch (DAOException exp) {
            this.addErrorMessage(null, "actionDelete.erroMessage", exp.getMessage(), new Object[0]);
        }
        if (this.dataItem != null) {
            try {
                this.dataItem = this.dataTable.getRowData();
            }
            catch (Exception exp) {
                this.dataItem = null;
            }
        }
        this.editMode = false;
        this.selectedIds.clear();
    }

    public String actionShowItem() {
        this.viewMode = ViewMode.FORM;
        this.dataItem = this.dataTable.getRowData();
        this.dataTable.setRows(1);
        EntityBackBean.log(this.dataItem);
        return null;
    }

    public void actionShowList() {
        this.viewMode = ViewMode.TABLE;
        this.dataItem = null;
        this.dataTable.setRows(this.getRowsPerPage());
    }

    public void actionShowForm() {
        this.viewMode = ViewMode.FORM;
        List selectedItems = this.getSelectedDataList();
        if (selectedItems.isEmpty()) {
            this.dataTable.setRowIndex(this.dataTable.getFirst());
            this.dataItem = this.dataTable.getRowData();
        } else {
            this.dataItem = selectedItems.get(0);
        }
        this.dataTable.setRows(1);
    }

    public String actionShow() {
        List selectedItems = this.getSelectedDataList();
        if (selectedItems.isEmpty()) {
            this.addWarnMessage(null, "actionShow.warnMessage", "Selecione pelo menos um item!", new Object[0]);
            return null;
        }
        EntityBackBean.log(selectedItems);
        return "selected";
    }

    public void setSelectedItem(ValueChangeEvent event) {
        this.selectedIds.put(EntityHelper.getValueId(this.dataTable.getRowData()), true);
    }

    public List getSelectedDataList() {
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        if (this.dataItem != null) {
            selectedItems.add(this.dataItem);
        } else {
            for (Object item : this.dataList) {
                if (this.getSelectedIds().isEmpty()) break;
                Object key = EntityHelper.getValueId(item);
                if (this.getSelectedIds().containsKey(key) && this.getSelectedIds().get(key).booleanValue()) {
                    selectedItems.add(item);
                    continue;
                }
                this.getSelectedIds().remove(key);
            }
        }
        return selectedItems;
    }

    @Override
    public boolean getDisabledNavigator() {
        return false;
    }

    @Override
    public boolean getRenderedNavigator() {
        return this.dataTable.getRows() > 0;
    }

    @Override
    public void actionFirst() {
        this.dataTable.setFirst(0);
        EntityBackBean.log(this.dataTable.getFirst());
        if (this.dataItem != null) {
            this.dataTable.setRowIndex(this.dataTable.getFirst());
            this.dataItem = this.dataTable.getRowData();
        }
    }

    @Override
    public boolean getDisabledActionFirst() {
        return this.dataTable.getFirst() == 0;
    }

    @Override
    public void actionPrevious() {
        int first = this.dataTable.getFirst() - this.dataTable.getRows();
        if (first < 0) {
            first = 0;
        }
        this.dataTable.setFirst(first);
        EntityBackBean.log(this.dataTable.getFirst());
        if (this.dataItem != null) {
            this.dataTable.setRowIndex(this.dataTable.getFirst());
            this.dataItem = this.dataTable.getRowData();
        }
    }

    @Override
    public boolean getDisabledActionPrevious() {
        return this.dataTable.getFirst() == 0;
    }

    @Override
    public void actionNext() {
        int first = this.dataTable.getFirst() + this.dataTable.getRows();
        if (this.dataTable.getRows() > this.dataTable.getRowCount()) {
            first = 0;
        } else if (first >= this.dataTable.getRowCount()) {
            first = this.dataTable.getRowCount() - 1;
        }
        this.dataTable.setFirst(first);
        EntityBackBean.log(this.dataTable.getFirst());
        if (this.dataItem != null) {
            this.dataTable.setRowIndex(this.dataTable.getFirst());
            this.dataItem = this.dataTable.getRowData();
        }
    }

    @Override
    public boolean getDisabledActionNext() {
        return this.dataTable.getFirst() + this.dataTable.getRows() >= this.dataTable.getRowCount();
    }

    @Override
    public void actionLast() {
        int rows = this.dataTable.getRows();
        if (rows != 0) {
            int count;
            int index = count - ((count = this.dataTable.getRowCount()) % rows != 0 ? count % rows : rows);
            this.dataTable.setFirst(index <= 0 ? 0 : index);
        }
        EntityBackBean.log(this.dataTable.getFirst());
        if (this.dataItem != null) {
            this.dataTable.setRowIndex(this.dataTable.getFirst());
            this.dataItem = this.dataTable.getRowData();
        }
    }

    @Override
    public boolean getDisabledActionLast() {
        return this.dataTable.getFirst() + this.dataTable.getRows() >= this.dataTable.getRowCount();
    }

    @Override
    public int getCurrent() {
        int rows = this.dataTable.getRows();
        if (rows != 0) {
            int first = this.dataTable.getFirst();
            int count = this.dataTable.getRowCount();
            if (count == 0) {
                return count;
            }
            return count / rows - (count - first) / rows + 1;
        }
        return 0;
    }

    @Override
    public int getTotalPages() {
        int rows = this.dataTable.getRows();
        if (rows != 0) {
            int count = this.dataTable.getRowCount();
            return count / rows + (count % rows != 0 ? 1 : 0);
        }
        return 1;
    }

    public List getDataList() {
        if (this.dataList == null) {
            this.actionLoad();
        }
        return this.dataList;
    }

    public void setDataList(List dataList) {
        this.dataList = dataList;
    }

    public Object getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(Object dataItem) {
        this.dataItem = dataItem;
    }

    public Map<Object, Boolean> getSelectedIds() {
        return this.selectedIds;
    }

    public void setSelectedIds(Map<Object, Boolean> selectedIds) {
        this.selectedIds = selectedIds;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public int getAddCount() {
        return this.addCount;
    }

    public void setAddCount(int addCount) {
        this.addCount = addCount;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
    }

    protected boolean isEditModeRow(Object dataItem) {
        Object id = EntityHelper.getValueId(dataItem);
        int size = this.dataList.size();
        boolean isSelected = this.getSelectedIds().containsKey(id) && this.getSelectedIds().get(id) != false || dataItem.equals(this.dataItem);
        boolean isNew = this.dataList.subList(size - this.getAddCount(), size).contains(dataItem);
        return this.editMode && (isSelected || isNew);
    }

    public boolean isEditModeRow() {
        if (this.isFormView()) {
            return this.editMode;
        }
        if (this.isTableView()) {
            return this.isEditModeRow(this.dataTable.getRowData());
        }
        return false;
    }

    public boolean isMultiSelect() {
        return this.rowsSelect != 0 && this.rowsSelect != 1;
    }

    public boolean isFormView() {
        return ViewMode.FORM.toString().equals(this.getViewMode().toString());
    }

    public boolean isTableView() {
        return ViewMode.TABLE.toString().equals(this.getViewMode().toString());
    }

    public UIComponentBase getEntityPanel() {
        return this.entityPanel;
    }

    public void setEntityPanel(UIComponentBase panelGroup) {
        this.entityPanel = panelGroup;
        this.extractProperties((UIComponent)this.entityPanel);
    }

    public UIData getDataTable() {
        if (this.dataTable == null && this.entityPanel != null) {
            this.extractProperties((UIComponent)this.entityPanel);
            String backBean = this.getBackBeanName();
            LinkedList<String> propertiyNames = new LinkedList<String>();
            if (this.showProperties != null) {
                for (String propertyName : this.showProperties.split(",")) {
                    propertiyNames.add(propertyName);
                }
            }
            ComponentFactory.getInstance("org.ajax4jsf.component.html.HtmlLoadScript").set("src", "resource:///util/jsf/js/jquery.maskedinput.js").setParent(this.entityPanel).createComponent();
            ComponentFactory.getInstance("entities.faces.jsf.components.MaskInputDate").setParent(this.entityPanel).createComponent();
            ComponentFactory.getInstance("entities.faces.jsf.components.MaskInputTime").setParent(this.entityPanel).createComponent();
            ComponentFactory.getInstance("org.ajax4jsf.component.html.HtmlQueue").set("requestDelay", 1000).set("ignoreDupResponce", true).setParent(this.entityPanel);
            this.dataTable = DesignerJSF.createDataTable(this.type, backBean, propertiyNames);
            this.autoForm = DesignerJSF.createForm(this.type, backBean);
            UIComponentBase panelGroup = ComponentFactory.getInstance(Types.PANEL_GRID).set("columns", 3).setParent(this.entityPanel).createComponent();
            ComponentFactory.getInstance(Types.COMMAND_BUTTON).setId("pageCurrentList").setParent(panelGroup).setAction("#{" + backBean + ".actionShowList}").setRendered("#{not " + backBean + ".tableView}").setImmediate(true).set("image", "resource:///entities/faces/jsf/resources/actionShowTable.gif").set("alt", I18N.getMessage("actionShowList.label", "Lista", new Object[0])).setHint(I18N.getMessage("actionShowList.hint", "Visualizar como lista", new Object[0]));
            ComponentFactory.getInstance(Types.COMMAND_BUTTON).setParent(panelGroup).setId("pageCurrentForm").setAction("#{" + backBean + ".actionShowForm}").setRendered("#{not " + backBean + ".formView}").setImmediate(true).set("image", "resource:///entities/faces/jsf/resources/actionShowForm.gif").set("alt", I18N.getMessage("paginator.action.first", "Form", new Object[0])).setHint(I18N.getMessage("actionShowForm.hint", "Visualizar como formul\u00e1rio", new Object[0]));
            panelGroup.getChildren().add(DesignerJSF.createNavigatorBar(backBean));
            panelGroup.getChildren().add(DesignerJSF.createPersistenceBar(backBean));
            this.entityPanel.getChildren().add(this.dataTable);
            this.entityPanel.getChildren().add(this.autoForm);
            this.dataTable.setRows(this.getRowsPerPage());
        }
        return this.dataTable;
    }

    public void setDataTable(UIData dataTable) {
        this.dataTable = dataTable;
    }

    public UIComponentBase getAutoForm() {
        return this.autoForm;
    }

    public void setAutoForm(UIComponentBase autoForm) {
        this.autoForm = autoForm;
    }

    public Boolean getRequestLive() {
        return this.requestLive;
    }

    public void setRequestLive(Boolean requestLive) {
        this.requestLive = requestLive;
    }

    public Boolean getShowActionDelete() {
        return this.showActionDelete;
    }

    public void setShowActionDelete(Boolean showActionDelete) {
        this.showActionDelete = showActionDelete;
    }

    public Boolean getShowActionEdit() {
        return this.showActionEdit;
    }

    public void setShowActionEdit(Boolean showActionEdit) {
        this.showActionEdit = showActionEdit;
    }

    public Boolean getShowActionNew() {
        return this.showActionNew;
    }

    public void setShowActionNew(Boolean showActionNew) {
        this.showActionNew = showActionNew;
    }

    public Boolean getShowRowNum() {
        return this.showRowNum;
    }

    public void setShowRowNum(Boolean showRowNum) {
        this.showRowNum = showRowNum;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public Integer getRowsSelect() {
        return this.rowsSelect;
    }

    public void setRowsSelect(Integer rowsSelect) {
        this.rowsSelect = rowsSelect;
    }

    public String getShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(String ShowProperties) {
        this.showProperties = ShowProperties;
    }

    public void extractProperties(UIComponent htmlEntityPanel) {
        Boolean bool;
        String value;
        if (htmlEntityPanel.getAttributes().containsKey(OQL)) {
            this.oql = new OQL(htmlEntityPanel.getAttributes().get(OQL).toString());
            try {
                this.type = Class.forName(this.oql.getClassResultName());
                this.dao = DAOFactory.getInstance().getDAO(this.type);
            }
            catch (ClassNotFoundException ex) {
                this.addExceptionMessage(ex, new Object[0]);
            }
            catch (Exception e) {
                this.addExceptionMessage(e, new Object[0]);
            }
        }
        if (htmlEntityPanel.getAttributes().containsKey(REQUEST_LIVE)) {
            value = htmlEntityPanel.getAttributes().get(REQUEST_LIVE).toString();
            if (value.startsWith("{") && value.endsWith("}")) {
                bool = Boolean.parseBoolean(EntityBackBean.evalEL(value.replace("{", "#{")).toString());
                this.setRequestLive(bool);
            } else {
                this.setRequestLive(Boolean.parseBoolean(htmlEntityPanel.getAttributes().get(REQUEST_LIVE).toString()));
            }
        }
        if (htmlEntityPanel.getAttributes().containsKey(ACTION_DELETE)) {
            value = htmlEntityPanel.getAttributes().get(ACTION_DELETE).toString();
            if (value.startsWith("{") && value.endsWith("}")) {
                bool = Boolean.parseBoolean(EntityBackBean.evalEL(value.replace("{", "#{")).toString());
                this.setShowActionDelete(bool);
            } else {
                this.setShowActionDelete(Boolean.parseBoolean(htmlEntityPanel.getAttributes().get(ACTION_DELETE).toString()));
            }
        }
        if (htmlEntityPanel.getAttributes().containsKey(ACTION_EDIT)) {
            value = htmlEntityPanel.getAttributes().get(ACTION_EDIT).toString();
            if (value.startsWith("{") && value.endsWith("}")) {
                bool = Boolean.parseBoolean(EntityBackBean.evalEL(value.replace("{", "#{")).toString());
                this.setShowActionEdit(bool);
            } else {
                this.setShowActionEdit(Boolean.parseBoolean(htmlEntityPanel.getAttributes().get(ACTION_EDIT).toString()));
            }
        }
        if (htmlEntityPanel.getAttributes().containsKey(ACTION_NEW)) {
            value = htmlEntityPanel.getAttributes().get(ACTION_NEW).toString();
            if (value.startsWith("{") && value.endsWith("}")) {
                bool = Boolean.parseBoolean(EntityBackBean.evalEL(value.replace("{", "#{")).toString());
                this.setShowActionNew(bool);
            } else {
                this.setShowActionNew(Boolean.parseBoolean(htmlEntityPanel.getAttributes().get(ACTION_NEW).toString()));
            }
        }
        if (htmlEntityPanel.getAttributes().containsKey(ROWS_PER_PAGE)) {
            this.setRowsPerPage(Integer.parseInt(htmlEntityPanel.getAttributes().get(ROWS_PER_PAGE).toString()));
        }
        if (htmlEntityPanel.getAttributes().containsKey(SHOW_ROW_NUM)) {
            this.setShowRowNum(Boolean.parseBoolean(htmlEntityPanel.getAttributes().get(SHOW_ROW_NUM).toString()));
        }
        if (htmlEntityPanel.getAttributes().containsKey(ROWS_SELECT)) {
            this.setRowsSelect(Integer.parseInt(htmlEntityPanel.getAttributes().get(ROWS_SELECT).toString()));
        }
        if (htmlEntityPanel.getAttributes().containsKey(SHOW_PROPERTIES)) {
            this.setShowProperties(htmlEntityPanel.getAttributes().get(SHOW_PROPERTIES).toString());
        }
    }

    private static void log(Object object) {
        System.out.println(new Exception().getStackTrace()[1].getMethodName() + ": " + object);
    }

    public static List<SelectItem> getSelectItems(String oql) throws DAOException {
        LinkedList<SelectItem> list = new LinkedList<SelectItem>();
        OQL o = new OQL(oql);
        IDAO idao = null;
        try {
            idao = DAOFactory.getInstance().getDAO(Class.forName(o.getClassBaseName()));
        }
        catch (ClassNotFoundException ex) {
            throw new DAOException("Classe " + o.getClassBaseName() + " n\u00e3o existe");
        }
        List entities = idao.query(oql);
        Collections.sort(entities, new EntityComparator(true));
        for (Object object : entities) {
            list.add(new SelectItem(object, object.toString()));
        }
        return list;
    }

    public void download(byte[] data) {
        if (data != null) {
            String fileName = "download";
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                ServletOutputStream os = response.getOutputStream();
                os.write(data);
                os.flush();
                os.close();
                FacesContext.getCurrentInstance().responseComplete();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void add(Collection collection, String element) {
        Object children = ObjectHelper.newInstance(element);
        if (children != null) {
            collection.add(children);
        }
    }

    public static enum ViewMode {
        TABLE,
        FORM;

    }

    public static enum State {
        BROWSE,
        EDIT,
        SEARCH;

    }
}

