/*
 * Decompiled with CFR 0.152.
 */
package entities.faces.jsf.components;

import entities.faces.jsf.components.HtmlInputRegex;
import entities.gui.jsf.converters.NumberConverter;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.faces.context.FacesContext;
import util.convert.I18N;

public class HtmlInputNumber
extends HtmlInputRegex {
    private static final String STYLE = "text-align: right; ";
    private Class<?> type = null;
    private Integer precision = 0;
    private Integer scale = 8;

    public HtmlInputNumber() {
        this.setStyle(STYLE);
        this.setConverter(new NumberConverter());
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    @Override
    public String getRegex() {
        Locale locale = I18N.getLocale();
        char separator = DecimalFormatSymbols.getInstance(locale).getDecimalSeparator();
        StringBuilder regex = new StringBuilder();
        if (this.scale > 0 || this.precision > 0) {
            regex.append("^[+\\-]?");
            if (this.scale > 0) {
                regex.append("[0-9]{0," + this.scale + "}");
            } else {
                regex.append("0\\" + separator);
            }
            if (this.precision > 0) {
                regex.append("(\\" + separator + "[0-9]{0," + this.precision + "})?");
            }
            regex.append("$");
        } else {
            regex.append("^[+\\-]?[0-9]{0,5}$");
        }
        return regex.toString();
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.precision, this.scale, this.type};
        return values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.precision = (Integer)values[1];
        this.scale = (Integer)values[2];
        this.type = (Class)values[3];
    }
}

