/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf;

import entities.annotations.Transaction;
import entities.dao.DAOValidationException;
import entities.gui.jsf.AutoEntityBackBean;
import entities.gui.jsf.commandImpl.DownloadCommand;
import entities.gui.jsf.commandImpl.NavigatorCommand;
import entities.gui.jsf.commandImpl.StringCommand;
import entities.gui.jsf.commandImpl.WorkbookCommand;
import entities.util.EntityValidator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import util.jsf.JSFContextHelper;
import util.jsf.MessageHelper;
import util.pattern.chain.ChainFactory;
import util.reflection.MethodHelper;

public abstract class ActionController
implements Serializable {
    private static String[] skins = new String[]{"blueSky", "classic", "ruby", "wine", "deepMarine", "emeraldTown", "japanCherry"};
    private static final String RESOURCE_PATH = "resource:///util/images/skin";
    private String id;
    private AutoEntityBackBean backbean;
    private String imageURL = "resource:///util/images/skin";
    private Object row;
    private Object actionOwner;
    private String actionName;
    private transient Object[] args;

    public String getId() {
        return this.getBackbean().getId();
    }

    public Object getRow() {
        return this.row;
    }

    public void setRow(Object row) {
        this.row = row;
    }

    public Object getActionOwner() {
        return this.actionOwner;
    }

    public void setActionOwner(Object actionOwner) {
        this.actionOwner = actionOwner;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Object[] getArgs() {
        if (this.args == null) {
            this.args = new Object[10];
        }
        return this.args;
    }

    public void setArgs(Object[] args) {
        this.args = args;
    }

    public AutoEntityBackBean getBackbean() {
        if (this.backbean == null && this instanceof AutoEntityBackBean) {
            this.backbean = (AutoEntityBackBean)this;
        }
        return this.backbean;
    }

    public void setBackbean(AutoEntityBackBean backbean) {
        this.backbean = backbean;
    }

    public void setImageURL(String imageURL) {
        this.imageURL = imageURL;
    }

    public String getImageURL() {
        return this.imageURL;
    }

    public String getImageURL(String imageName) {
        return this.getImageURL(imageName, true);
    }

    public String getImageURL(String imageName, boolean enabled) {
        Size size = Size.SMALL;
        String image = this.imageURL;
        if (enabled) {
            boolean isSkin = false;
            String skin = JSFContextHelper.getContextParamDefault("org.richfaces.SKIN", "");
            for (String skin2 : skins) {
                if (!skin.equals(skin2)) continue;
                isSkin = true;
                break;
            }
            if (isSkin) {
                image = image + "/" + skin;
            }
        } else {
            image = image + "/disabled";
        }
        image = image + "/" + imageName + size.toString() + ".png";
        return image;
    }

    public void addInfoMessage(String key, String defaultMessage, Object ... args) {
        MessageHelper.getInstance().addInfoMessage(this.getId(), key, defaultMessage, args);
    }

    public void addWarnMessage(String key, String defaultMessage, Object ... args) {
        MessageHelper.getInstance().addWarnMessage(this.getId(), key, defaultMessage, args);
    }

    public void addErrorMessage(String key, String defaultMessage, Object ... args) {
        MessageHelper.getInstance().addErrorMessage(this.getId(), key, defaultMessage, args);
    }

    public void addFatalMessage(String key, String defaultMessage, Object ... args) {
        MessageHelper.getInstance().addFatalMessage(this.getId(), key, defaultMessage, args);
    }

    public void addExceptionMessage(Exception ex, Object ... args) {
        MessageHelper.getInstance().addExceptionMessage(this.getId(), ex, args);
    }

    public Object processAction() throws Throwable {
        Object result = null;
        Object selectRow = this.getRow();
        Class<?> owner = this.getActionOwner();
        if (owner == null) {
            owner = this.getBackbean().getEntity();
        }
        Method method = MethodHelper.getMethod(owner, this.getActionName());
        Object[] mainArgs = Arrays.copyOfRange(this.getArgs(), 0, method.getParameterTypes().length);
        if (method != null && method.isAnnotationPresent(Transaction.class)) {
            try {
                EntityValidator ev;
                this.getBackbean().getDao().beginTransaction();
                if (selectRow != null) {
                    this.getBackbean().getDao().save(selectRow);
                    this.getBackbean().getDao().load(selectRow);
                }
                result = MethodHelper.invoke(owner, this.getActionName(), mainArgs);
                if (selectRow != null && (ev = new EntityValidator(selectRow)).hasErrors()) {
                    throw new DAOValidationException(ev.getMessage());
                }
                this.getBackbean().getDao().commit();
                this.getBackbean().setDataList(null);
            }
            catch (Exception ex) {
                try {
                    this.getBackbean().getDao().rollback();
                }
                catch (Exception exc) {
                    ex = new Exception(exc.getMessage(), ex);
                }
                this.addExceptionMessage(ex, new Object[0]);
            }
        } else {
            try {
                result = MethodHelper.invoke(owner, this.getActionName(), mainArgs);
            }
            catch (Exception ex) {
                this.addExceptionMessage(ex, new Object[0]);
            }
        }
        ChainFactory.createChainActions(new NavigatorCommand(), new StringCommand(), new DownloadCommand(), new WorkbookCommand()).startChain(result);
        return result;
    }

    public static enum Size {
        SMALL("_16x16"),
        MEDIUM("_24x24"),
        LARGE("_32x32");

        private String size;

        private Size(String size) {
            this.size = size;
        }

        public String toString() {
            return this.size;
        }
    }
}

