/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf;

import entities.dao.DAOFactory;
import entities.dao.IDAO;
import entities.dao.oql.OQL;
import entities.descriptor.ViewDescriptor;
import entities.gui.jsf.ActionController;
import entities.gui.jsf.EntityDesignerJSF;
import entities.gui.jsf.components.Upload;
import entities.util.EntityLazyList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.component.UIForm;
import org.ajax4jsf.model.KeepAlive;
import util.jsf.BackBeanViewPage;
import util.jsf.JSFContextHelper;
import util.reflection.ClassHelper;

@KeepAlive
public class AutoEntityBackBean
extends ActionController
implements Serializable {
    private static final String PARAM_VIEW = "view";
    private String view;
    private String title;
    private Class<?> entity;
    protected Map<String, Object> pageFilters = new HashMap<String, Object>();
    private List dataList = null;
    private Set editRows = new HashSet();
    private List newsRows = new ArrayList();
    private Set selectedRows = new HashSet();
    private int rows = 10;
    private transient UIComponentBase autoEntity;
    private transient UIForm autoForm;
    private transient UIData autoDataTable;
    private transient String backBeanName;
    private OQL oql;
    private IDAO dao;
    private String query;

    public String getView() {
        if (this.view == null) {
            this.view = this.getAutoEntity().getAttributes().get(PARAM_VIEW) != null ? this.getAutoEntity().getAttributes().get(PARAM_VIEW).toString() : (String)JSFContextHelper.getRequestParameterMapValue(PARAM_VIEW);
        }
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Class<?> getEntity() {
        if (this.entity == null && this.getView() != null) {
            String entityClassName = this.getView().split("@")[0];
            this.entity = ClassHelper.getClass(entityClassName);
        }
        return this.entity;
    }

    public void setEntity(Class<?> entity) {
        this.entity = entity;
    }

    public Map<String, Object> getPageFilters() {
        return this.pageFilters;
    }

    public void setPageFilters(Map<String, Object> pageFilters) {
        this.pageFilters = pageFilters;
    }

    public String getBackBeanName() {
        if (this.backBeanName == null) {
            this.backBeanName = BackBeanViewPage.lookupBackBeanName(this);
        }
        return this.backBeanName;
    }

    @Override
    public String getId() {
        return this.autoEntity.getId();
    }

    public IDAO getDao() {
        if (this.dao == null) {
            this.dao = DAOFactory.getInstance().getDAO(this.getEntity());
        }
        return this.dao;
    }

    public void setDao(IDAO dao) {
        this.dao = dao;
    }

    public List getDataList() {
        if (this.dataList == null) {
            this.update();
            Map<String, Object> params = this.getOql().getParams();
            for (Map.Entry<String, Object> param : params.entrySet()) {
                this.getOql().setParam(param.getKey(), this.getParam(param.getKey()));
            }
            this.dataList = new EntityLazyList(this.getOql(), this.getAutoDataTable().getRows());
            this.addInfoMessage("Ctrl.DAO.result.sucess", "{0} registro(s) encontrado(s)", this.dataList.size());
        }
        return this.dataList;
    }

    public void setDataList(List dataList) {
        this.dataList = dataList;
    }

    public List getNewsRows() {
        return this.newsRows;
    }

    public void setNewsRows(List newsRows) {
        this.newsRows = newsRows;
    }

    public Set getEditRows() {
        return this.editRows;
    }

    public void setEditRows(Set editRows) {
        this.editRows = editRows;
    }

    public Set getSelectedRows() {
        return this.selectedRows;
    }

    public void setSelectedRows(Set selectedRows) {
        this.selectedRows = selectedRows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public boolean isEditModeRow(Object row) {
        return this.getEditRows().size() > 0 && this.getEditRows().contains(row) || this.getNewsRows().size() > 0 && this.getNewsRows().contains(row);
    }

    public boolean isInsertModeRow(Object row) {
        return this.getNewsRows().size() > 0 && this.getNewsRows().contains(row);
    }

    private String getViewName() {
        return this.getView().substring(this.getView().indexOf("@") + 1);
    }

    private String getQuery() {
        return this.query;
    }

    private OQL getOql() {
        if (this.oql == null) {
            this.oql = new OQL(this.getQuery());
        }
        return this.oql;
    }

    private Object getParam(String paramName) {
        Object value = null;
        for (UIComponent comp : this.getAutoEntity().getChildren()) {
            if (!comp.getClass().getSimpleName().equals("UIParameter") || comp.getAttributes() == null || comp.getAttributes().get("name") == null || !comp.getAttributes().get("name").equals(paramName)) continue;
            value = comp.getAttributes().get("value");
        }
        return value;
    }

    private void update() {
        this.getOql().clear();
        for (Map.Entry<String, Object> entry : this.pageFilters.entrySet()) {
            if (entry.getValue() == null || entry.getValue().toString().isEmpty()) continue;
            this.getOql().addFilter(entry.getKey(), entry.getValue());
        }
        Map<String, Object> params = this.getOql().getParams();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() != null) continue;
            param.setValue(JSFContextHelper.getMapValue(param.getKey()));
        }
    }

    public void setAutoEntity(UIComponentBase autoEntity) {
        this.autoEntity = autoEntity;
    }

    public UIComponentBase getAutoEntity() {
        return this.autoEntity;
    }

    public UIForm getAutoForm() {
        return this.autoForm;
    }

    public void setAutoForm(UIForm autoForm) {
        this.autoForm = autoForm;
    }

    public UIData getAutoDataTable() {
        if (this.autoDataTable == null && this.getEntity() != null) {
            ViewDescriptor descriptor = new ViewDescriptor(this.getEntity(), this.getViewName());
            this.title = descriptor.getTitle();
            this.query = descriptor.getNamedQuery();
            this.setRows(descriptor.getRows());
            this.autoDataTable = EntityDesignerJSF.createDataTable(this.autoEntity, (UIComponentBase)this.autoForm, descriptor, this.getBackBeanName());
            if (AutoEntityBackBean.containsUpload((UIComponent)this.autoDataTable)) {
                this.autoForm.getAttributes().put("enctype", "multipart/form-data");
            }
        }
        return this.autoDataTable;
    }

    public void setAutoDataTable(UIData dataTable) {
        this.autoDataTable = dataTable;
    }

    private static boolean containsUpload(UIComponent base) {
        UIComponent kid = null;
        boolean result = false;
        Iterator kids = base.getFacetsAndChildren();
        while (kids.hasNext() && !result) {
            kid = (UIComponent)kids.next();
            if (kid instanceof Upload) {
                result = true;
                continue;
            }
            result = AutoEntityBackBean.containsUpload(kid);
        }
        return result;
    }
}

