/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class EntityNavigationHandler
extends NavigationHandler {
    public static final String REDIRECT_PREFIX = "redirect";
    NavigationHandler _base;

    public EntityNavigationHandler(NavigationHandler base) {
        this._base = base;
    }

    public void handleNavigation(FacesContext facesContext, String fromAction, String outcome) {
        if (outcome == null) {
            return;
        }
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String targetViewId = this.getTargetViewId(facesContext, outcome);
        if (this.isRedirect(outcome)) {
            ExternalContext externalContext = facesContext.getExternalContext();
            String redirectPath = viewHandler.getActionURL(facesContext, targetViewId);
            try {
                externalContext.redirect(externalContext.encodeActionURL(redirectPath));
            }
            catch (IOException e) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
        } else {
            this._base.handleNavigation(facesContext, fromAction, outcome);
        }
    }

    private boolean isRedirect(String outcome) {
        return outcome.startsWith(REDIRECT_PREFIX);
    }

    private String getTargetViewId(FacesContext facesContext, String outcome) {
        String targetViewId;
        String viewSuffix = this.getDefaultViewSuffix(facesContext);
        if (this.isRedirect(outcome)) {
            String pageName = outcome.split(":")[1];
            targetViewId = "/" + pageName + (pageName.contains("?") ? "" : viewSuffix);
        } else {
            targetViewId = outcome;
        }
        return targetViewId;
    }

    private String getDefaultViewSuffix(FacesContext facesContext) {
        String suffix = facesContext.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
        return suffix != null ? suffix : ".jsp";
    }
}

