/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf;

import entities.EntityException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.model.KeepAlive;
import util.convert.FileHelper;
import util.convert.FileUtil;

@KeepAlive
public class FileBackBean
implements Serializable {
    public static void download(File file) {
        try {
            byte[] data = FileHelper.readBytes(file);
            String fileName = file.getName();
            String mime = FileUtil.getMime(file);
            FileBackBean.download(data, fileName, mime);
        }
        catch (IOException ex) {
            throw new EntityException(ex);
        }
    }

    public static void download(byte[] data) {
        if (data != null && data.length > 0) {
            String extension = FileUtil.getExtensionFile(data);
            String fileName = "download" + extension;
            String mime = FileUtil.getMime(data);
            FileBackBean.download(data, fileName, mime);
        }
    }

    public static void download(byte[] data, String fileName, String mime) {
        if (data != null && data.length > 0) {
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            response.setContentType(mime);
            response.addHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                ServletOutputStream os = response.getOutputStream();
                os.write(data);
                os.flush();
                os.close();
                FacesContext.getCurrentInstance().responseComplete();
            }
            catch (Exception ex) {
                throw new EntityException(ex);
            }
        }
    }
}

