/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.commandImpl;

import java.io.OutputStream;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import util.jsf.MessageHelper;
import util.pattern.chain.Command;

public class WorkbookCommand
extends Command {
    @Override
    public Command.Chain execute(Object object) {
        String fileName = "planilha.xls";
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (array.length == 2 && array[0] instanceof Workbook && array[1] instanceof String) {
                object = array[0];
                fileName = array[1].toString();
            } else {
                return Command.Chain.CONTINUE;
            }
        }
        if (object instanceof Workbook) {
            Workbook data = (Workbook)object;
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            response.setContentType("application/octet-stream");
            response.addHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                ServletOutputStream os = response.getOutputStream();
                data.write((OutputStream)os);
                os.flush();
                os.close();
                FacesContext.getCurrentInstance().responseComplete();
            }
            catch (Exception ex) {
                MessageHelper.getInstance().addExceptionMessage(ex, new Object[0]);
            }
            return Command.Chain.STOP;
        }
        return Command.Chain.CONTINUE;
    }
}

