/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.components;

import entities.gui.jsf.components.DynamicImage;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicImageTagPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -2711890280803223561L;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewRootId = ((HttpServletRequest)facesContext.getExternalContext().getRequest()).getRequestURI();
        if (viewRootId != null && viewRootId.indexOf(DynamicImage.getViewID()) != -1) {
            this.serveResource(facesContext, viewRootId);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    private void serveResource(FacesContext facesContext, String viewId) {
        try {
            Map sessionMap = facesContext.getExternalContext().getSessionMap();
            String resourceKey = DynamicImageTagPhaseListener.getResourceKey(viewId);
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            if (!sessionMap.containsKey(resourceKey)) {
                response.sendError(404, "Image not found");
                facesContext.responseComplete();
            } else {
                Object obj = sessionMap.remove(resourceKey);
                if (obj instanceof byte[]) {
                    response.setStatus(200);
                    Calendar c = Calendar.getInstance();
                    c.add(13, 3600000);
                    response.setHeader("Pragma", "cache");
                    response.setHeader("Cache-Control", "PUBLIC, max-age=360000000");
                    response.setHeader("Expires", DynamicImageTagPhaseListener.htmlExpiresDateFormat().format(c.getTime()));
                    ServletOutputStream os = response.getOutputStream();
                    os.write((byte[])obj);
                    os.flush();
                    os.close();
                    facesContext.responseComplete();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading resource", e);
        }
    }

    private static String getResourceKey(String viewId) {
        String resource = viewId.substring(viewId.lastIndexOf(47) + 1, viewId.length());
        resource = resource.indexOf(46) != -1 ? resource.substring(0, resource.indexOf(46)) : resource;
        return resource;
    }

    public static DateFormat htmlExpiresDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat;
    }
}

