/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.components;

import entities.gui.jsf.components.Tooltip;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class TooltipRender
extends Renderer {
    public static final String RENDER_TYPE = "entities.gui.jsf.components.tooltip";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String id = component.getClientId(context);
        id = id.replaceAll(":", "-");
        writer.startElement("style", component);
        writer.writeAttribute("type", (Object)"text/css", "type");
        writer.writeText((Object)this.generateComponentStyle(id, context.getExternalContext().getRequestContextPath()), component, null);
        writer.endElement("style");
        writer.startElement("a", component);
        writer.writeAttribute("id", (Object)id, "id");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        Map attributes = component.getAttributes();
        String id = component.getClientId(context);
        Tooltip tooltip = (Tooltip)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)(id + "_tooltip"), "id");
        writer.writeAttribute("class", (Object)"tooltip", "styleClass");
        writer.startElement("span", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)(id + "_top"), "id");
        writer.writeAttribute("class", (Object)"top", "styleClass");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)(id + "_middle"), "id");
        writer.writeAttribute("class", (Object)"middle", "styleClass");
        writer.startElement("div", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)(id + "_content"), "id");
        writer.writeAttribute("class", attributes.get("styleClass"), "styleClass");
        writer.writeAttribute("style", attributes.get("style"), "styleClass");
        UIComponent content = tooltip.getTootipContent();
        if (content != null) {
            content.encodeBegin(context);
            content.encodeChildren(context);
            content.encodeEnd(context);
        } else {
            writer.writeText(attributes.get("value"), component, null);
        }
        writer.endElement("div");
        writer.endElement("span");
        writer.startElement("span", (UIComponent)tooltip);
        writer.writeAttribute("id", (Object)(id + "_bottom"), "id");
        writer.writeAttribute("class", (Object)"bottom", "styleClass");
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("a");
    }

    private String generateComponentStyle(String id, String context) {
        StringBuilder css = new StringBuilder();
        css.append("#" + id + " { ");
        css.append("\tposition:relative; ");
        css.append("\tz-index:24; ");
        css.append("\ttext-decoration:none; ");
        css.append("} ");
        css.append("#" + id + " span.tooltip{ display: none; } ");
        css.append("#" + id + ":hover{ z-index:25; color: #aaaaff; background:;} ");
        css.append("#" + id + ":hover span.tooltip{ ");
        css.append("\tdisplay:block; ");
        css.append("\tposition:absolute; ");
        css.append("\ttop:0px; left:0; ");
        css.append("\tpadding: 10px 0 0 0; ");
        css.append("\twidth:200px; ");
        css.append("\tcolor: #993300; ");
        css.append("\ttext-align: center; ");
        css.append("\tfilter: alpha(opacity:95); ");
        css.append("\tKHTMLOpacity: 0.95; ");
        css.append("\tMozOpacity: 0.95; ");
        css.append("\topacity: 0.95; ");
        css.append("} ");
        css.append("#" + id + ":hover span.top{ ");
        css.append("\tdisplay: block; ");
        css.append("\tpadding: 30px 8px 0; ");
        css.append("\tbackground: url(" + context + "/img/bubble.gif) no-repeat top; ");
        css.append("} ");
        css.append("#" + id + ":hover span.middle, #" + id + ":hover span.middle span{ ");
        css.append("\tdisplay: block; ");
        css.append("\tpadding: 0 8px;  ");
        css.append("\tfont-family:\"Trebuchet MS\", Arial, Verdana, sans-serif;  ");
        css.append("\tfont-size: 12px; ");
        css.append("\tbackground: url(" + context + "/img/bubble_filler.gif) repeat bottom; ");
        css.append("} ");
        css.append("#" + id + ":hover span.bottom{ ");
        css.append("\tdisplay: block; ");
        css.append("\tpadding:3px 8px 10px; ");
        css.append("\tcolor: #548912; ");
        css.append("\tbackground: url(" + context + "/img/bubble.gif) no-repeat bottom; ");
        css.append("} ");
        return css.toString();
    }
}

