/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.components;

import entities.gui.jsf.components.UploadRequestWrapper;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadFilter
implements Filter {
    private int sizeThreshold = -1;
    private String repositoryPath;

    public void init(FilterConfig config) throws ServletException {
        this.repositoryPath = config.getInitParameter("entities.gui.jsf.components.UploadFilter.repositoryPath");
        try {
            String paramValue = config.getInitParameter("entities.gui.jsf.components.UploadFilter.sizeThreshold");
            if (paramValue != null) {
                this.sizeThreshold = Integer.parseInt(paramValue);
            }
        }
        catch (NumberFormatException ex) {
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        boolean isMultipartContent = ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest);
        if (!isMultipartContent) {
            chain.doFilter(request, response);
        } else {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            if (this.sizeThreshold >= 0) {
                factory.setSizeThreshold(this.sizeThreshold);
            }
            if (this.repositoryPath != null) {
                factory.setRepository(new File(this.repositoryPath));
            }
            UploadRequestWrapper wrapper = new UploadRequestWrapper(httpRequest, (FileItemFactory)factory);
            chain.doFilter((ServletRequest)wrapper, response);
        }
    }
}

