/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.components;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String> formParameters;
    private Map<String, FileItem> fileParameters;

    public UploadRequestWrapper(HttpServletRequest request, FileItemFactory factory) throws ServletException {
        super(request);
        try {
            ServletFileUpload upload = new ServletFileUpload();
            upload.setFileItemFactory(factory);
            List fileItems = upload.parseRequest(request);
            this.formParameters = new HashMap<String, String>();
            this.fileParameters = new HashMap<String, FileItem>();
            for (int i = 0; i < fileItems.size(); ++i) {
                FileItem item = (FileItem)fileItems.get(i);
                if (item.isFormField()) {
                    this.formParameters.put(item.getFieldName(), item.getString());
                    continue;
                }
                this.fileParameters.put(item.getFieldName(), item);
                request.setAttribute(item.getFieldName(), (Object)item);
            }
        }
        catch (FileUploadException ex) {
            ServletException servletEx = new ServletException();
            servletEx.initCause((Throwable)ex);
            throw servletEx;
        }
        catch (Exception ne) {
            throw new RuntimeException(ne);
        }
    }

    public String getParameter(String name) {
        if (this.formParameters.get(name) != null) {
            return this.formParameters.get(name);
        }
        if (this.fileParameters.get(name) != null) {
            return "file";
        }
        return null;
    }

    public Enumeration getFileNames() {
        return Collections.enumeration(this.fileParameters.keySet());
    }

    public FileItem getFile(String name) {
        return this.fileParameters.get(name);
    }

    public Map getParameterMap() {
        return this.formParameters;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.formParameters.keySet());
    }

    public String[] getParameterValues(String arg0) {
        String[] values = new String[this.formParameters.size()];
        Iterator<String> iter = this.formParameters.values().iterator();
        for (int i = 0; i < values.length; ++i) {
            values[i] = iter.next();
        }
        return values;
    }
}

