/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.controllerImpl;

import entities.annotations.ActionDescriptor;
import entities.dao.DAOConstraintException;
import entities.dao.DAOException;
import entities.dao.DAOValidationException;
import entities.gui.jsf.controllerImpl.ListController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.faces.component.UIData;

public class DAOController
extends ListController {
    @ActionDescriptor(shortDescription="Novo", methodDisabled="#{this.disabledCreate()}", image="#{this.imageCreate()}")
    public void create() {
        Object entity = this.getBackbean().getDao().newInstance(this.getBackbean().getEntity());
        this.getBackbean().getNewsRows().add(entity);
        this.getBackbean().getDataList().add(this.getBackbean().getNewsRows().size() - 1, entity);
    }

    public boolean disabledCreate() {
        return this.getBackbean().getEditRows().size() > 0;
    }

    public String imageCreate() {
        return this.getImageURL("round_add", !this.disabledCreate());
    }

    @ActionDescriptor(shortDescription="Excluir", confirm=true, confirmMessage="Deseja exclu\u00edr o(s) registro(s) selecionado(s)?", image="#{this.imageDelete()}", methodDisabled="#{this.disabledDelete()}")
    public void delete() {
        try {
            if (this.getBackbean().getSelectedRows() != null && this.getBackbean().getSelectedRows().size() > 0) {
                int size = this.getBackbean().getSelectedRows().size();
                this.getBackbean().getDao().delete(this.getBackbean().getSelectedRows().toArray());
                this.getBackbean().getSelectedRows().clear();
                this.getBackbean().setDataList(null);
                this.addInfoMessage("Ctrl.DAO.delete.sucess", "{0} registro(s) exclu\u00eddo(s)", size);
            } else {
                this.addWarnMessage(null, "Ctrl.DAO.delete.warn", "N\u00e3o h\u00e1 regitro(s) selecionado(s) para exclus\u00e3o");
            }
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("{DAOConstraintException.message}", ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            this.addWarnMessage("{Exception.message}", ex.getMessage(), new Object[0]);
        }
    }

    public boolean disabledDelete() {
        return this.getBackbean().getSelectedRows().size() == 0 || this.getBackbean().getNewsRows().size() > 0 || this.getBackbean().getEditRows().size() > 0;
    }

    public String imageDelete() {
        return this.getImageURL("trash", !this.disabledDelete());
    }

    @ActionDescriptor(shortDescription="Alterar", methodDisabled="#{this.disabledEdit()}", image="#{this.imageEdit()}")
    public void edit() {
        if (this.getBackbean().getSelectedRows() != null) {
            this.getBackbean().getEditRows().addAll(this.getBackbean().getSelectedRows());
        }
    }

    public boolean disabledEdit() {
        return this.getBackbean().getSelectedRows().size() == 0 || this.getBackbean().getEditRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    public String imageEdit() {
        return this.getImageURL("edit", !this.disabledEdit());
    }

    @ActionDescriptor(shortDescription="Salvar", methodRendered="#{this.renderedSaveOrCancel()}", image="#{this.imageSave()}")
    public void save() {
        try {
            if (this.getBackbean().getNewsRows().size() > 0 || this.getBackbean().getEditRows().size() > 0) {
                HashSet objects = new HashSet(this.getBackbean().getEditRows());
                objects.addAll(this.getBackbean().getNewsRows());
                this.getBackbean().getDao().save(objects.toArray());
                this.getBackbean().getNewsRows().clear();
                this.getBackbean().getEditRows().clear();
                this.getBackbean().getSelectedRows().clear();
                this.getSelectedIds().clear();
                this.getBackbean().setDataList(null);
                this.addInfoMessage("Ctrl.DAO.savePage.sucess", "{0} registro(s) salvo(s)", objects.size());
            }
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("DAOConstraintException.message", ex.getMessage(), new Object[0]);
        }
        catch (DAOException ex) {
            this.addWarnMessage("DAOException.message", ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            this.addWarnMessage("Exception.message", ex.getMessage(), new Object[0]);
        }
    }

    public String imageSave() {
        return this.getImageURL("save", true);
    }

    @ActionDescriptor(shortDescription="Cancelar", methodRendered="#{this.renderedSaveOrCancel()}", image="#{this.imageCancel()}", immediate=true)
    public void cancel() {
        this.getBackbean().getNewsRows().clear();
        this.getBackbean().getEditRows().clear();
        this.getBackbean().getSelectedRows().clear();
        this.getBackbean().setDataList(null);
    }

    public String imageCancel() {
        return this.getImageURL("cancel", true);
    }

    public boolean renderedSaveOrCancel() {
        return this.getBackbean().getEditRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    @ActionDescriptor(shortDescription="Excluir", confirm=true, confirmMessage="Deseja exclu\u00edr este registro?", image="#{this.imageDeleteRow()}", methodDisabled="#{this.disabledDeleteRow()}")
    public void deleteRow() {
        try {
            Object entity = this.getRow();
            this.getBackbean().getDao().delete(entity);
            this.getBackbean().getDataList().remove(entity);
            this.getBackbean().setDataList(null);
            this.addInfoMessage("Ctrl.DAO.deleteRow.sucess", "{0} registro(s) exclu\u00eddo(s)", this.getBackbean().getSelectedRows().size());
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("{DAOConstraintException.message}", ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            this.addWarnMessage("{Exception.message}", ex.getMessage(), new Object[0]);
        }
    }

    public boolean disabledDeleteRow() {
        return this.getBackbean().getSelectedRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0 || this.getBackbean().getEditRows().size() > 0;
    }

    public String imageDeleteRow() {
        return this.getImageURL("trash", !this.disabledDelete());
    }

    @ActionDescriptor(shortDescription="Alterar", methodDisabled="#{this.disabledEditRow()}", image="#{this.imageEditRow()}")
    public void editRow() {
        Object entity = this.getRow();
        this.getBackbean().getEditRows().add(entity);
    }

    public boolean disabledEditRow() {
        return this.getBackbean().getSelectedRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    public String imageEditRow() {
        return this.getImageURL("edit", !this.disabledEditRow());
    }

    @ActionDescriptor(shortDescription="Salvar", methodRendered="#{this.renderedSaveOrCancelRow()}", image="#{this.imageSaveRow('save')}")
    public void saveRow() {
        try {
            Object entity = this.getRow();
            this.getBackbean().getDao().save(entity);
            this.getBackbean().getEditRows().remove(entity);
            this.getBackbean().getNewsRows().remove(entity);
            this.addInfoMessage("Ctrl.DAO.saveRow.sucess", "Registro(s) salvo(s)", new Object[0]);
        }
        catch (DAOValidationException ex) {
            this.addWarnMessage("DAOValidationException.message", ex.getMessage(), new Object[0]);
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("DAOConstraintException.message", ex.getMessage(), new Object[0]);
        }
        catch (DAOException ex) {
            this.addErrorMessage("DAOException.message", ex.getMessage(), new Object[0]);
        }
    }

    public String imageSaveRow() {
        return this.getImageURL("save", true);
    }

    @ActionDescriptor(shortDescription="Cancelar", methodRendered="#{this.renderedSaveOrCancelRow()}", image="#{this.imageCancelRow()}", immediate=true)
    public void cancelRow() {
        Object entity = this.getRow();
        this.getBackbean().getEditRows().remove(entity);
        this.getBackbean().getNewsRows().remove(entity);
    }

    public String imageCancelRow() {
        return this.getImageURL("cancel", true);
    }

    public boolean renderedSaveOrCancelRow() {
        Object entity = null;
        try {
            entity = this.getBackbean().getAutoDataTable().getRowData();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.getBackbean().getEditRows().contains(entity) || this.getBackbean().getNewsRows().contains(entity);
    }

    @ActionDescriptor(shortDescription="Excluir", confirm=true, confirmMessage="Deseja exclu\u00edr o(s) registro(s) da p\u00e1gina?", image="#{this.imageDeletePage()}", methodDisabled="#{this.disabledDeletePage()}")
    public void deletePage() {
        try {
            List rowsPage = this.getRowsPage();
            if (rowsPage.size() > 0) {
                this.getBackbean().getDao().delete(this.getRowsPage().toArray());
                this.getBackbean().setDataList(null);
                this.addInfoMessage("Ctrl.DAO.deletePage.sucess", "{0} registro(s) exclu\u00eddo(s)", rowsPage.size());
            } else {
                this.addWarnMessage(null, "Ctrl.DAO.deletePage.warn", "N\u00e3o h\u00e1 registros para excluir");
            }
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("{DAOConstraintException.message}", ex.getMessage(), new Object[0]);
        }
        catch (Exception ex) {
            this.addWarnMessage("{Exception.message}", ex.getMessage(), new Object[0]);
        }
    }

    public String imageDeletePage() {
        return this.getImageURL("trash", !this.disabledDeletePage());
    }

    public boolean disabledDeletePage() {
        return this.getBackbean().getDataList() == null || this.getBackbean().getDataList().size() == 0 || this.getBackbean().getEditRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    @ActionDescriptor(shortDescription="Alterar", image="#{this.imageEditPage()}", methodDisabled="#{this.disabledEditPage()}")
    public void editPage() {
        List rowsPage = this.getRowsPage();
        if (rowsPage.size() > 0) {
            this.getBackbean().getEditRows().addAll(rowsPage);
        } else {
            this.addWarnMessage("Ctrl.DAO.editPage.warn", "N\u00e3o h\u00e1 registros para alterar", new Object[0]);
        }
    }

    public String imageEditPage() {
        return this.getImageURL("edit", !this.disabledEditPage());
    }

    public boolean disabledEditPage() {
        return this.getBackbean().getDataList() == null || this.getBackbean().getDataList().size() == 0 || this.getBackbean().getEditRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    @ActionDescriptor(shortDescription="Salvar", image="#{this.imageSavePage('save')}", methodRendered="#{this.renderedSaveOrCancelPage()}")
    public void savePage() {
        try {
            List rowsPage = this.getRowsPage();
            this.getBackbean().getDao().save(rowsPage.toArray());
            this.getBackbean().getNewsRows().clear();
            this.getBackbean().getEditRows().clear();
            this.getBackbean().setDataList(null);
            this.addInfoMessage("Ctrl.DAO.savePage.sucess", "{0} registro(s) salvo(s)", rowsPage.size());
        }
        catch (DAOValidationException ex) {
            this.addWarnMessage("DAOValidationException.message", ex.getMessage(), new Object[0]);
        }
        catch (DAOConstraintException ex) {
            this.addWarnMessage("DAOConstraintException.message", ex.getMessage(), new Object[0]);
        }
        catch (DAOException ex) {
            this.addErrorMessage("DAOException.message", ex.getMessage(), new Object[0]);
        }
    }

    public String imageSavePage() {
        return this.getImageURL("save", true);
    }

    @ActionDescriptor(shortDescription="Cancelar", methodRendered="#{this.renderedSaveOrCancelPage()}", image="#{this.imageCancelPage()}", immediate=true)
    public void cancelPage() {
        this.getBackbean().getNewsRows().clear();
        this.getBackbean().getEditRows().clear();
        this.getBackbean().setDataList(null);
    }

    public String imageCancelPage() {
        return this.getImageURL("cancel", true);
    }

    public boolean renderedSaveOrCancelPage() {
        return this.getBackbean().getEditRows().size() > 0 || this.getBackbean().getNewsRows().size() > 0;
    }

    private List getRowsPage() {
        ArrayList objects = new ArrayList();
        UIData dataTable = this.getBackbean().getAutoDataTable();
        for (int i = 0; i < this.getBackbean().getDataList().size(); ++i) {
            if (i < dataTable.getFirst() || i >= dataTable.getFirst() + dataTable.getRows()) continue;
            objects.add(this.getBackbean().getDataList().get(i));
        }
        return objects;
    }
}

