/*
 * Decompiled with CFR 0.152.
 */
package entities.gui.jsf.converters;

import entities.faces.jsf.components.HtmlInputNumber;
import entities.faces.jsf.components.HtmlOutputNumber;
import java.text.NumberFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import util.convert.Convert;
import util.convert.I18N;

public class NumberConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent comp, String value) {
        Object obj = null;
        if (value != null && !value.isEmpty()) {
            Convert conv = new Convert(I18N.getLocale());
            if (comp instanceof HtmlInputNumber) {
                HtmlInputNumber input = (HtmlInputNumber)comp;
                obj = conv.convert(value, input.getType());
            } else {
                obj = conv.convert(value, Double.class);
            }
        }
        return obj;
    }

    public String getAsString(FacesContext context, UIComponent comp, Object value) {
        NumberFormat numberFormat = NumberFormat.getInstance(I18N.getLocale());
        if (comp instanceof HtmlOutputNumber) {
            HtmlOutputNumber input = (HtmlOutputNumber)comp;
            numberFormat.setMinimumFractionDigits(input.getPrecision());
        }
        return numberFormat.format(value);
    }
}

