/*
 * Decompiled with CFR 0.152.
 */
package entities.usecases;

import entities.EntityException;
import entities.usecases.Actor;
import entities.usecases.Package;
import entities.usecases.UseCase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class EntitiesUseCases {
    private List<Package> packages = new ArrayList<Package>();
    private List<Actor> actors = new ArrayList<Actor>();
    private Map<String, Set<String>> viewsActors;
    private String name;
    private String description;
    private static EntitiesUseCases instance;

    private EntitiesUseCases() {
    }

    public static EntitiesUseCases getInstance() {
        return instance;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="actor")
    public List<Actor> getActors() {
        return this.actors;
    }

    public void setActors(List<Actor> actors) {
        this.actors = actors;
    }

    @XmlElement(name="package")
    public List<Package> getPackages() {
        return this.packages;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public Set<String> getActorsSet(String viewName) {
        if (this.viewsActors == null) {
            this.montaViewsActors();
        }
        return this.viewsActors.get(viewName);
    }

    public synchronized boolean hasActor(String viewName, String actorName) {
        Set<String> xactors = this.getActorsSet(viewName);
        return xactors != null && xactors.contains(actorName);
    }

    private void montaViewsActors() {
        if (this.viewsActors == null) {
            for (Actor a : this.getActors()) {
                if (a.getSuperActor() == null) continue;
                a.getSuperActor().getSubActors().add(a);
            }
            this.viewsActors = new HashMap<String, Set<String>>();
            for (Package pk : this.getPackages()) {
                for (UseCase uc : pk.getUseCases()) {
                    uc.registraViewsActors(this.viewsActors, null);
                }
            }
        }
    }

    static {
        try {
            InputStream is = EntitiesUseCases.class.getResourceAsStream("/EntitiesUseCases.xml");
            instance = (EntitiesUseCases)JAXBContext.newInstance((Class[])new Class[]{EntitiesUseCases.class}).createUnmarshaller().unmarshal(is);
        }
        catch (Exception ex) {
            throw new EntityException("N\u00e3o foi poss\u00edvel instanciar casos de uso 'EntitiesUseCases.xml'!", ex);
        }
    }
}

