/*
 * Decompiled with CFR 0.152.
 */
package entities.usecases;

import entities.usecases.Actor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;

public class UseCase {
    private String name;
    private String description;
    private String viewName;
    private List<Actor> actors = new ArrayList<Actor>();
    private List<UseCase> extensions = new ArrayList<UseCase>();
    private List<UseCase> includes = new ArrayList<UseCase>();

    @XmlElement
    @XmlID
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="actor")
    @XmlIDREF
    public List<Actor> getActors() {
        return this.actors;
    }

    public void setActors(List<Actor> actors) {
        this.actors = actors;
    }

    @XmlElementWrapper(name="extensions")
    @XmlElement(name="useCase")
    public List<UseCase> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<UseCase> extensions) {
        this.extensions = extensions;
    }

    @XmlElementWrapper(name="includes")
    @XmlElement(name="useCase")
    public List<UseCase> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<UseCase> includes) {
        this.includes = includes;
    }

    public void getViewsSet(Set<String> set) {
        set.add(this.getViewName());
        for (UseCase useCase : this.getExtensions()) {
            useCase.getViewsSet(set);
        }
        for (UseCase useCase : this.getIncludes()) {
            useCase.getViewsSet(set);
        }
    }

    protected void registraViewsActors(Map<String, Set<String>> viewsActors, Set<String> vactors) {
        Set<String> xactors = vactors;
        if (xactors == null) {
            xactors = new HashSet<String>();
            for (Actor a : this.getActors()) {
                xactors.add(a.getName());
                for (Actor b : a.getSubActors()) {
                    xactors.add(b.getName());
                }
            }
        }
        if (this.getViewName() != null) {
            Set<String> yactors = viewsActors.get(this.getViewName());
            if (yactors == null) {
                yactors = new HashSet<String>();
                viewsActors.put(this.getViewName(), yactors);
            }
            yactors.addAll(xactors);
        }
        for (UseCase uc : this.getExtensions()) {
            uc.registraViewsActors(viewsActors, xactors);
        }
        for (UseCase uc : this.getIncludes()) {
            uc.registraViewsActors(viewsActors, xactors);
        }
    }

    public boolean containsActor(String actorName) {
        for (Actor actor : this.getActors()) {
            if (!actor.getName().equals(actorName)) continue;
            return true;
        }
        return false;
    }
}

