/*
 * Decompiled with CFR 0.152.
 */
package entities.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class EntityComparator
implements Comparator<Object>,
Serializable {
    private List<String> getters = new ArrayList<String>();
    private boolean ascending;

    public EntityComparator(boolean ascending) {
        this.ascending = ascending;
    }

    public EntityComparator(String getter, boolean ascending) {
        for (String name : getter.split("\\.")) {
            if (!name.startsWith("get")) {
                name = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            this.getters.add(name);
        }
        this.ascending = ascending;
    }

    public EntityComparator(String getter) {
        this(getter, true);
    }

    @Override
    public int compare(Object o1, Object o2) {
        try {
            Iterator<String> iter = this.getters.iterator();
            while (o1 != null && o2 != null && iter.hasNext()) {
                String getter = iter.next();
                o1 = o1.getClass().getMethod(getter, new Class[0]).invoke(o1, new Object[0]);
                o2 = o2.getClass().getMethod(getter, new Class[0]).invoke(o2, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot compare " + o1 + " with " + o2 + " on " + this.getters, e);
        }
        if (o1 instanceof Comparable) {
            if (this.ascending) {
                return o1 == null ? -1 : (o2 == null ? 1 : ((Comparable)o1).compareTo(o2));
            }
            return o1 == null ? 1 : (o2 == null ? -1 : ((Comparable)o2).compareTo(o1));
        }
        if (this.ascending) {
            return o1.toString().compareTo(o2.toString());
        }
        return o2.toString().compareTo(o1.toString());
    }
}

