/*
 * Decompiled with CFR 0.152.
 */
package entities.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;

public final class EntityHelper {
    private static final Map<String, String> namedQueriesCache = new LinkedHashMap<String, String>();

    private EntityHelper() {
    }

    public static Object getValueId(Object instanceObject) {
        Object valueId = null;
        if (!EntityHelper.isEntity(instanceObject)) {
            throw new RuntimeException("A classe " + instanceObject.getClass().getName() + " n\u00e3o marcada @Entity");
        }
        block3: for (Class<?> c = instanceObject.getClass(); c != null; c = c.getSuperclass()) {
            for (final Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                try {
                    valueId = field.get(instanceObject);
                    continue block3;
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException("O objeto passado como argumento \u00e9 inv\u00e1lido", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("O Id do objeto " + instanceObject.toString() + " n\u00e3o pode ser acessado", ex);
                }
            }
        }
        return valueId;
    }

    public static void setValueId(Object instanceObject, Object valueId) {
        if (!EntityHelper.isEntity(instanceObject)) {
            throw new IllegalArgumentException("A classe " + instanceObject.getClass().getName() + " n\u00e3o marcada @Entity");
        }
        block3: for (Class<?> c = instanceObject.getClass(); c != null; c = c.getSuperclass()) {
            for (final Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                try {
                    field.set(instanceObject, valueId);
                    continue block3;
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("O objeto passado como argumento \u00e9 inv\u00e1lido", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("O Id do objeto " + instanceObject.toString() + " n\u00e3o pode ser acessado", ex);
                }
            }
        }
    }

    public static boolean equals(Object entityX, Object entityY) throws IllegalAccessException {
        if (entityX == entityY) {
            return true;
        }
        if (entityX == null || entityY == null) {
            return false;
        }
        Object idX = EntityHelper.getValueId(entityX);
        Object idY = EntityHelper.getValueId(entityY);
        if (idX == null || idY == null) {
            return false;
        }
        return idX.equals(idY);
    }

    public static String[] getNamedQueries(Class clazz) {
        ArrayList<String> listNamedQueries = new ArrayList<String>();
        NamedQueries namedQueriesAnnotation = clazz.getAnnotation(NamedQueries.class);
        if (namedQueriesAnnotation != null) {
            for (NamedQuery namedQuery : namedQueriesAnnotation.value()) {
                listNamedQueries.add(namedQuery.name());
                namedQueriesCache.put(namedQuery.name(), namedQuery.query());
            }
        }
        return listNamedQueries.toArray(new String[listNamedQueries.size()]);
    }

    public static String getNamedQuery(Class clazz, String namedQuery) {
        String query = null;
        if (clazz.isAnnotationPresent(NamedQueries.class)) {
            NamedQueries namedQueris = clazz.getAnnotation(NamedQueries.class);
            for (NamedQuery nq : namedQueris.value()) {
                if (!nq.name().equals(namedQuery)) continue;
                query = nq.query();
                break;
            }
        }
        return query;
    }

    public static String getNamedQuery(String namedQueryName) {
        return namedQueriesCache.get(namedQueryName);
    }

    public static boolean isEntity(Object entity) {
        return entity.getClass().isAnnotationPresent(Entity.class);
    }
}

