/*
 * Decompiled with CFR 0.152.
 */
package entities.util;

import entities.dao.DAOException;
import entities.dao.DAOFactory;
import entities.dao.IDAO;
import entities.dao.oql.OQL;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.reflection.ClassHelper;

public class EntityLazyList
extends AbstractList
implements Serializable {
    private static final int DEFAULT_SIZE = 20;
    OQL oql;
    Map<Integer, Object> loaded = new HashMap<Integer, Object>();
    Long size;
    int pageSize = 20;
    private IDAO dao;

    public EntityLazyList(OQL oql, int pageSize) {
        this.oql = oql;
        if (pageSize > 0) {
            this.pageSize = pageSize;
        }
    }

    @Override
    public Object get(int i) {
        if (!this.loaded.containsKey(i)) {
            List results;
            int pageIndex = i / this.pageSize;
            Object[] params = this.oql.getParams().values().toArray();
            String command = this.oql.getOQLCommand();
            try {
                results = this.getDAO().query(command, pageIndex * this.pageSize, this.pageSize, params);
                this.size = this.getDAO().queryCount(command, params);
            }
            catch (DAOException ex) {
                throw new RuntimeException(ex);
            }
            for (int j = 0; j < results.size(); ++j) {
                this.loaded.put(pageIndex * this.pageSize + j, results.get(j));
            }
        }
        return this.loaded.get(i);
    }

    @Override
    public int size() {
        if (this.size == null) {
            this.get(0);
        }
        return Integer.valueOf(this.size.toString());
    }

    private IDAO getDAO() {
        if (this.dao == null) {
            Class clazz = ClassHelper.getClass(this.oql.getClassResultName());
            this.dao = DAOFactory.getInstance().getDAO(clazz);
        }
        return this.dao;
    }

    @Override
    public void add(int index, Object element) {
        if (index < 0 || (long)index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int oldSize = this.loaded.size();
        this.loaded.put(index, element);
        if (this.loaded.size() > oldSize) {
            this.size = (long)this.size() + 1L;
        }
    }
}

