/*
 * Decompiled with CFR 0.152.
 */
package entities.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import util.convert.I18N;
import util.reflection.ClassHelper;

public class EntityValidator {
    private transient List<InvalidValue> listOfInvalidValue = new LinkedList<InvalidValue>();

    public EntityValidator(Object ... entities) {
        ResourceBundle bundle = I18N.getResourceBundle();
        for (Object object : entities) {
            InvalidValue[] invalidValues;
            Class classBean = ClassHelper.getClass(object);
            ClassValidator classValidator = bundle == null ? new ClassValidator(classBean) : new ClassValidator(classBean, bundle);
            for (InvalidValue invalidValue : invalidValues = classValidator.getInvalidValues(object)) {
                this.listOfInvalidValue.add(invalidValue);
            }
        }
    }

    public boolean hasErrors() {
        return this.listOfInvalidValue.size() > 0;
    }

    public String getMessage() {
        StringBuilder msg = new StringBuilder();
        for (InvalidValue iv : this.listOfInvalidValue) {
            msg.append(iv.getPropertyName() + " : ");
            if (iv.getValue() != null) {
                msg.append(" \"" + iv.getValue() + "\" ");
            }
            msg.append(" " + iv.getMessage() + "\n");
        }
        return msg.toString();
    }

    public List<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        for (InvalidValue iv : this.listOfInvalidValue) {
            StringBuilder msg = new StringBuilder(iv.getPropertyName() + " : ");
            if (iv.getValue() != null) {
                msg.append(" \"" + iv.getValue() + "\" ");
            }
            msg.append(" " + iv.getMessage());
            messages.add(msg.toString());
        }
        return messages;
    }
}

