/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;

public class Convert {
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    public static final Locale LocaleBR = new Locale("pt", "BR");
    public static ConvertUtilsBean converterBR = null;
    private Locale locale;
    private ConvertUtilsBean converter;

    public Convert(Locale locale) {
        this.locale = locale;
        this.converter = Convert.getConverter(this.locale);
    }

    public Object convert(String string, Class clazz) {
        return this.converter.convert(string, clazz);
    }

    public static ConvertUtilsBean getConverter(Locale locale) {
        ConvertUtilsBean conv = new ConvertUtilsBean();
        conv.register((Converter)new ByteLocaleConverter(locale), Byte.TYPE);
        conv.register((Converter)new ByteLocaleConverter(locale), Byte.class);
        conv.register((Converter)new ShortLocaleConverter(locale), Short.TYPE);
        conv.register((Converter)new ShortLocaleConverter(locale), Short.class);
        conv.register((Converter)new IntegerLocaleConverter(locale), Integer.class);
        conv.register((Converter)new IntegerLocaleConverter(locale), Integer.TYPE);
        conv.register((Converter)new LongLocaleConverter(locale), Long.TYPE);
        conv.register((Converter)new LongLocaleConverter(locale), Long.class);
        conv.register((Converter)new MyFloatLocaleConverter(locale), Float.TYPE);
        conv.register((Converter)new MyFloatLocaleConverter(locale), Float.class);
        conv.register((Converter)new DoubleLocaleConverter(locale), Double.class);
        conv.register((Converter)new DoubleLocaleConverter(locale), Double.TYPE);
        conv.register((Converter)new BigIntegerLocaleConverter(locale), BigInteger.class);
        conv.register((Converter)new BigDecimalLocaleConverter(locale), BigDecimal.class);
        conv.register((Converter)new DateLocaleConverter(locale), java.util.Date.class);
        conv.register((Converter)new SqlDateLocaleConverter(locale), Date.class);
        return conv;
    }

    @Deprecated
    public static java.util.Date stringToDate(String stringDate) throws ParseException {
        return Convert.stringToDate(stringDate, DATE_FORMAT);
    }

    public static java.util.Date stringToDate(String stringDate, String stringFormat) throws ParseException {
        if (stringDate == null || stringDate.equals("")) {
            throw new IllegalArgumentException("String n\u00e3o pode ser vazia");
        }
        java.util.Date date = null;
        SimpleDateFormat formatador = new SimpleDateFormat(stringFormat);
        date = formatador.parse(stringDate);
        return date;
    }

    public static String dateToString(java.util.Date date, String format, Locale locale) {
        SimpleDateFormat formatador = new SimpleDateFormat(format, locale);
        String novoFormato = formatador.format(date);
        return novoFormato;
    }

    public static String dateToString(java.util.Date date, String format) {
        return Convert.dateToString(date, format, Locale.getDefault());
    }

    public static String dateToString(java.util.Date date) {
        return Convert.dateToString(date, DATE_FORMAT, Locale.getDefault());
    }

    public static String timeToString(java.util.Date date) {
        return Convert.dateToString(date, TIME_FORMAT);
    }

    public static String timeToString(java.util.Date date, String format) {
        return Convert.dateToString(date, format);
    }

    public static String dateTimeToString(java.util.Date date, String format) {
        return Convert.dateToString(date, format, Locale.getDefault());
    }

    public static String dateTimeToString(java.util.Date date) {
        return Convert.dateToString(date, DATE_TIME_FORMAT, Locale.getDefault());
    }

    static class MyFloatLocaleConverter
    extends FloatLocaleConverter {
        private MyFloatLocaleConverter(Locale locale) {
            super(locale);
        }

        public Object convert(Class clazz, Object value) {
            try {
                return super.convert(clazz, value);
            }
            catch (ConversionException ex) {
                return Float.valueOf(0.0f);
            }
        }
    }
}

