/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import java.util.HashMap;
import java.util.Locale;
import util.convert.StringUtil;

public class ConvertNames {
    protected static final String[] patternNames = new String[]{"Action", "Simgleton", "Factory", "Wrapper", "Facade", "Parte"};

    public static String plural(String name) {
        Locale locale = Locale.getDefault();
        if ((locale.getLanguage() + locale.getCountry()).equals("En")) {
            return ConvertNames.pluralEn(name);
        }
        return ConvertNames.pluralPtBr(name);
    }

    private static String pluralEn(String singularNoun) {
        String pluralNoun = singularNoun;
        int nounLength = pluralNoun.length();
        if (nounLength == 1) {
            pluralNoun = pluralNoun + 's';
        } else if (nounLength > 1) {
            char secondToLastChar = pluralNoun.charAt(nounLength - 2);
            if (pluralNoun.endsWith("y")) {
                switch (secondToLastChar) {
                    case 'a': 
                    case 'e': 
                    case 'i': 
                    case 'o': 
                    case 'u': {
                        pluralNoun = pluralNoun + 's';
                        break;
                    }
                    default: {
                        pluralNoun = pluralNoun.substring(0, nounLength - 1) + "ies";
                        break;
                    }
                }
            } else if (pluralNoun.endsWith("s")) {
                switch (secondToLastChar) {
                    case 's': {
                        pluralNoun = pluralNoun + "es";
                        break;
                    }
                    default: {
                        pluralNoun = pluralNoun + "ses";
                        break;
                    }
                }
            } else {
                pluralNoun = pluralNoun + 's';
            }
        }
        return pluralNoun;
    }

    private static String pluralPtBr(String name) {
        if ((Locale.getDefault().getLanguage() + Locale.getDefault().getCountry()).equals("ptBR")) {
            // empty if block
        }
        boolean change = false;
        String pluralName = null;
        HashMap<String, String> suffixes = new HashMap<String, String>();
        suffixes.put("l", "is");
        suffixes.put("L", "IS");
        suffixes.put("m", "ns");
        suffixes.put("M", "NS");
        suffixes.put("r", "res");
        suffixes.put("R", "RES");
        suffixes.put("s", "ses");
        suffixes.put("S", "SES");
        suffixes.put("z", "es");
        suffixes.put("Z", "ES");
        suffixes.put("x", "x");
        suffixes.put("X", "X");
        suffixes.put("ao", "oes");
        suffixes.put("AO", "OES");
        suffixes.put("\u00e3o", "\u00f5es");
        suffixes.put("\u00c3O", "\u00d5ES");
        for (String suffix : suffixes.keySet()) {
            if (!name.endsWith(suffix)) continue;
            pluralName = StringUtil.removeSuffixes(name, suffix) + (String)suffixes.get(suffix);
            change = true;
            break;
        }
        if (!change) {
            pluralName = Character.isLowerCase(name.charAt(name.length() - 1)) ? name + 's' : name + 'S';
        }
        return pluralName;
    }

    public static boolean isFemale(String name) {
        boolean result = false;
        if (name != null && !name.isEmpty()) {
            return StringUtil.hasSuffixes(name.toLowerCase(), "a", "de");
        }
        return result;
    }

    public static String naturalName(String name) {
        if (name != null && !name.isEmpty()) {
            name = StringUtil.removePrefixes(name, patternNames);
            name = StringUtil.removeSuffixes(name, patternNames);
            int length = name.length();
            if (name.length() <= 1) {
                return name.toUpperCase();
            }
            StringBuffer naturalName = new StringBuffer(length);
            char character = Character.toUpperCase(name.charAt(0));
            naturalName.append(character);
            char nextCharacter = name.charAt(1);
            for (int pos = 2; pos < length; ++pos) {
                char previousCharacter = character;
                character = nextCharacter;
                nextCharacter = name.charAt(pos);
                if (previousCharacter != ' ') {
                    if (Character.isUpperCase(character) && !Character.isUpperCase(previousCharacter)) {
                        naturalName.append(' ');
                    }
                    if (Character.isUpperCase(character) && Character.isLowerCase(nextCharacter) && Character.isUpperCase(previousCharacter)) {
                        naturalName.append(' ');
                    }
                    if (Character.isDigit(character) && !Character.isDigit(previousCharacter)) {
                        naturalName.append(' ');
                    }
                }
                naturalName.append(character);
            }
            naturalName.append(nextCharacter);
            return naturalName.toString();
        }
        return name;
    }
}

