/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import java.io.File;
import java.io.IOException;

public class FileUtil {
    private static final String[] ENCODINGS = new String[]{"ISO-8859-1", "UTF-8", "UTF-16"};
    private static final byte[] GIF_87a = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] GIF_89a = new byte[]{71, 73, 70, 56, 57, 97};
    private static final byte[] JPEG = new byte[]{-1, -40, -1, -32};
    private static final byte[] PNG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] BMP = new byte[]{66, 77};
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_GIF = "image/gif";
    public static final String CONTENT_TYPE_JPEG = "image/jpeg";
    public static final String CONTENT_TYPE_PNG = "image/png";
    public static final String CONTENT_TYPE_BMP = "image/bmp";
    public static final String CONTENT_TYPE_OCTET = "application/octet-stream";
    public static final String CONTENT_TYPE_CSV = "text/comma-separated-values";
    public static final String CONTENT_TYPE_CSV2 = "text/csv";

    public static String getMime(byte[] content) {
        String mime = CONTENT_TYPE_OCTET;
        if (FileUtil.isJPEG(content)) {
            mime = CONTENT_TYPE_JPEG;
        } else if (FileUtil.isBMP(content)) {
            mime = CONTENT_TYPE_BMP;
        } else if (FileUtil.isGIF(content)) {
            mime = CONTENT_TYPE_GIF;
        } else if (FileUtil.isPNG(content)) {
            mime = CONTENT_TYPE_PNG;
        } else if (FileUtil.isPDF(content)) {
            mime = "application/pdf";
        } else if (FileUtil.isZIP(content)) {
            mime = "application/zip";
        }
        return mime;
    }

    public static String getMime(File file) {
        String mime = CONTENT_TYPE_OCTET;
        if (FileUtil.isJPEG(file)) {
            mime = CONTENT_TYPE_JPEG;
        } else if (FileUtil.isBMP(file)) {
            mime = CONTENT_TYPE_BMP;
        } else if (FileUtil.isGIF(file)) {
            mime = CONTENT_TYPE_GIF;
        } else if (FileUtil.isPNG(file)) {
            mime = CONTENT_TYPE_PNG;
        } else if (FileUtil.isPDF(file)) {
            mime = "application/pdf";
        } else if (FileUtil.isZIP(file)) {
            mime = "application/zip";
        }
        return mime;
    }

    public static String getExtensionFile(byte[] data) {
        String ext = "";
        try {
            if (FileUtil.isJPEG(data)) {
                ext = ".jpeg";
            } else if (FileUtil.isBMP(data)) {
                ext = ".bmp";
            } else if (FileUtil.isGIF(data)) {
                ext = ".gif";
            } else if (FileUtil.isPNG(data)) {
                ext = ".png";
            } else if (FileUtil.isPDF(data)) {
                ext = ".pdf";
            } else if (FileUtil.isZIP(data)) {
                ext = ".zip";
            } else if (FileUtil.isXML(data)) {
                ext = ".xml";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ext;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isJPEG(byte[] content) {
        boolean result = false;
        if (content.length >= 2 && content[0] == -1 && content[1] == -40 && content[2] == -1) {
            result = true;
        }
        return result;
    }

    public static boolean isJPEG(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("jpeg") || ext.equals("jpg");
    }

    public static boolean isBMP(byte[] content) {
        boolean result = false;
        if (content.length >= 2 && content[0] == 66 && content[1] == 77) {
            result = true;
        }
        return result;
    }

    public static boolean isBMP(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("bpm");
    }

    public static boolean isGIF(byte[] content) {
        boolean result = false;
        if (content.length >= 6 && (content[0] == 71 && content[1] == 73 && content[2] == 70 && content[3] == 56 && content[4] == 55 && content[5] == 97 || content[0] == 71 && content[1] == 73 && content[2] == 70 && content[3] == 56 && content[4] == 57 && content[5] == 97)) {
            result = true;
        }
        return result;
    }

    public static boolean isGIF(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("gif");
    }

    public static boolean isPNG(byte[] content) {
        boolean result = false;
        if (content.length >= 8 && content[0] == -119 && content[1] == 80 && content[2] == 78 && content[3] == 71 && content[4] == 13 && content[5] == 10 && content[6] == 26 && content[7] == 10) {
            result = true;
        }
        return result;
    }

    public static boolean isPNG(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("png");
    }

    public static boolean isPDF(byte[] content) {
        boolean result = false;
        if (content.length >= 64 && content[0] == 37 && content[1] == 80 && content[2] == 68 && content[3] == 70 && content[4] == 45 && content[5] == 49 && content[6] == 46) {
            result = true;
        }
        return result;
    }

    public static boolean isPDF(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("pdf");
    }

    public static boolean isZIP(byte[] content) {
        boolean result = false;
        if (content.length >= 64 && content[0] == 80 && content[1] == 75 && content[2] == 3 && content[3] == 4) {
            result = true;
        }
        return result;
    }

    public static boolean isZIP(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("zip");
    }

    public static boolean isXML(byte[] content) throws IOException {
        boolean result = false;
        if (content.length >= 3) {
            for (String currEncoding : ENCODINGS) {
                String temp = new String(content, currEncoding);
                if (temp.indexOf("<?xml") < 0 || temp.indexOf("?>") <= 0) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean isXML(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("xml");
    }

    public static boolean isUtf16Text(byte[] content) throws IOException {
        boolean result = false;
        if (content.length >= 2 && content[0] == -1 && content[1] == -1) {
            int estimate = (content.length - 2) / 3;
            if (FileUtil.count(content, (byte)0) > estimate) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isEncrypted(byte[] content) throws IOException {
        boolean result = false;
        if (!(content.length <= 0 || content.length % 8 != 0 || FileUtil.isPDF(content) || FileUtil.isXML(content) || FileUtil.isZIP(content) || FileUtil.isUtf16Text(content))) {
            for (int i = 0; i < content.length; ++i) {
                if (!FileUtil.isAsciiControl((char)content[i])) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isTXT(File f) {
        String ext = FileUtil.getExtension(f);
        return ext.equals("txt");
    }

    public static boolean isHtml(File f) {
        String ext = FileUtil.getExtension(f);
        if (ext.equals("html")) {
            return true;
        }
        return ext.equals("htm");
    }

    private static boolean isAsciiControl(char ch) {
        if (ch >= '\u0000' && ch <= '\u001f') {
            return true;
        }
        return true;
    }

    private static int count(byte[] content, byte value) {
        int result = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != value) continue;
            ++result;
        }
        return result;
    }
}

