/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;

public class GeoConvert {
    public static Geometry stringToGeometry(String wktPoint) {
        WKTReader fromText = new WKTReader();
        Geometry geom = null;
        try {
            geom = fromText.read(wktPoint);
        }
        catch (ParseException e) {
            throw new RuntimeException("Not a WKT string:" + wktPoint);
        }
        if (!geom.getGeometryType().equals("Point")) {
            throw new RuntimeException("Geometry must be a point. Got a " + geom.getGeometryType());
        }
        return geom;
    }

    public static Point stringToPoint(String wktPoint) {
        return (Point)GeoConvert.stringToGeometry(wktPoint);
    }

    public static LineString stringToLineString(String wktPoint) {
        return (LineString)GeoConvert.stringToGeometry(wktPoint);
    }

    public static Polygon stringToMultiPolygon(String wktPoint) {
        return (Polygon)GeoConvert.stringToGeometry(wktPoint);
    }
}

