/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;

public class I18N {
    private static final String I18N_DEFAULT = "i18n";
    private static String i18nFileName;

    public static String getI18nFileName() {
        if (i18nFileName == null) {
            i18nFileName = I18N_DEFAULT;
            try {
                Class.forName("javax.faces.context.FacesContext");
                if (FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getApplication().getMessageBundle() != null) {
                    i18nFileName = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return i18nFileName;
    }

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            Class.forName("javax.faces.context.FacesContext");
            if (FacesContext.getCurrentInstance() != null) {
                locale = FacesContext.getCurrentInstance().getApplication().getDefaultLocale() != null ? FacesContext.getCurrentInstance().getApplication().getDefaultLocale() : FacesContext.getCurrentInstance().getViewRoot().getLocale();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return locale;
    }

    public static ResourceBundle getResourceBundle() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(I18N.getI18nFileName(), I18N.getLocale());
        }
        catch (Exception ex) {
            bundle = null;
        }
        return bundle;
    }

    public static String getMessage(String key, String messageDefault, Object ... parametros) {
        String message = I18N.isKey(key) ? I18N.extractKey(key) : key;
        try {
            ResourceBundle bundle = I18N.getResourceBundle();
            message = bundle.getString(message);
        }
        catch (Exception ex) {
            message = "" + messageDefault;
        }
        return MessageFormat.format(message, parametros);
    }

    public static boolean isKey(String value) {
        return value != null && value.trim().startsWith("{") && value.trim().endsWith("}");
    }

    public static String extractKey(String key) {
        if (key == null) {
            return "";
        }
        if (I18N.isKey(key)) {
            return key.trim().substring(1, key.trim().length() - 1);
        }
        return key;
    }
}

