/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import util.reflection.ObjectHelper;

public class ResourceHelper {
    private String resourceFileName;

    public ResourceHelper(String resourceFileName) {
        this.resourceFileName = resourceFileName;
    }

    private ResourceBundle getResourceBundle() {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(this.resourceFileName, Locale.getDefault());
        }
        catch (Exception ex) {
            bundle = null;
        }
        return bundle;
    }

    public String getPropertyValue(String key, String stringDefault) {
        String propertyValue = null;
        try {
            ResourceBundle bundle = this.getResourceBundle();
            propertyValue = bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            propertyValue = stringDefault;
        }
        catch (NullPointerException ex) {
            propertyValue = stringDefault;
        }
        return propertyValue;
    }

    public Integer getPropertyValueAsInteger(String key, Integer valueDefault) {
        Integer propertyValue = null;
        try {
            ResourceBundle bundle = this.getResourceBundle();
            propertyValue = Integer.valueOf(bundle.getString(key));
        }
        catch (MissingResourceException ex) {
            propertyValue = valueDefault;
        }
        catch (NullPointerException ex) {
            propertyValue = valueDefault;
        }
        return propertyValue;
    }

    public Object getPropertyValueAsObject(String key, Object valueDefault) {
        Object propertyValue = null;
        try {
            ResourceBundle bundle = this.getResourceBundle();
            propertyValue = ObjectHelper.newInstance(bundle.getString(key));
        }
        catch (MissingResourceException ex) {
            propertyValue = valueDefault;
        }
        catch (NullPointerException ex) {
            propertyValue = valueDefault;
        }
        return propertyValue;
    }
}

