/*
 * Decompiled with CFR 0.152.
 */
package util.convert;

public class StringUtil {
    public static final char SPACE = ' ';
    public static final String QUOTE = "'";
    public static final String PERCENT = "%";
    public static final String ASTERISC = "*";

    public static String upperCaseFirstLetter(String string) {
        String result = null;
        if (string != null) {
            result = string.length() == 1 ? string.toUpperCase() : (string.length() > 1 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string);
        }
        return result;
    }

    public static String lowerCaseFirstLetter(String string) {
        String result = null;
        if (string != null) {
            result = string.length() == 1 ? string.toLowerCase() : (string.length() > 1 ? Character.toLowerCase(string.charAt(0)) + string.substring(1) : string);
        }
        return result;
    }

    public static String removeSuffixes(String string, String ... suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (!string.endsWith(suffix)) continue;
                return string.substring(0, string.length() - suffix.length());
            }
        }
        return string;
    }

    public static boolean hasSuffixes(String string, String ... suffixes) {
        if (suffixes != null) {
            for (String suffix : suffixes) {
                if (suffix.isEmpty() || !string.endsWith(suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static String removePrefixes(String string, String ... prefixes) {
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (prefix.isEmpty() || !string.startsWith(prefix)) continue;
                string = string.substring(prefix.length());
            }
        }
        return string;
    }

    public static boolean hasPrefixes(String string, String ... prefixes) {
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (prefix.isEmpty() || !string.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static synchronized String pad(String stringToPad, int size, char charPad, Padding padType) {
        StringBuffer str = new StringBuffer(stringToPad);
        int strLength = str.length();
        if (size > 0 && size > strLength) {
            for (int i = 0; i <= size; ++i) {
                if (padType.equals((Object)Padding.LEFT)) {
                    if (i >= size - strLength) continue;
                    str.insert(0, charPad);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(charPad);
            }
        }
        return str.toString();
    }

    public static String LPad(String stringToPad, int size) {
        return StringUtil.pad(stringToPad, size, ' ', Padding.LEFT);
    }

    public static String RPad(String stringToPad, int size) {
        return StringUtil.pad(stringToPad, size, ' ', Padding.RIGTH);
    }

    public static enum Padding {
        LEFT,
        RIGTH;

    }
}

